import { _decorator, assetManager, Button, Component, director, EditBox, Node } from 'cc';
import { GameMgr } from './GameMgr';
const { ccclass, property } = _decorator;

@ccclass('MainDemoCtrl')
export class MainDemoCtrl extends Component {
    @property(EditBox)
    private editBox: EditBox = null;

    @property(Button)
    private submitBtn: Button = null;

    @property(Button)
    private nextPageBtn: Button = null;


    start() {
        this.submitBtn.node.on(Button.EventType.CLICK, this.onButtonClick, this);
        this.nextPageBtn.node.on(Button.EventType.CLICK, this.onNextPageClick, this);
    }

    onButtonClick() {
        console.log(this.editBox.string);
        GameMgr.getInstance().addScore(this.editBox.string);
        console.log('getScore', GameMgr.getInstance().getScore());
    }

    onNextPageClick() {
        this.loadRemoteBundle();
        // this.loadLocalBundle();
    }

    loadRemoteBundle() {
        assetManager.loadBundle('http://192.168.31.253:8080/remote/remote-bundle-demo', (err, bundle) => {
            if (err) {
                console.error('Failed to load bundle:', err);
                return;
            }
            bundle.loadScene('remote-demo', (err, scene) => {
                if (err) {
                    console.error('Failed to load scene:', err);
                    return;
                }
                director.runScene(scene);
            });
        });
    }

    loadLocalBundle() {
        assetManager.loadBundle('remote-bundle-demo', (err, bundle) => {
            if (err) {
                console.error('Failed to load bundle:', err);
                return;
            }
            bundle.loadScene('remote-demo', (err, scene) => {
                if (err) {
                    console.error('Failed to load scene:', err);
                    return;
                }
                director.runScene(scene);
            });
        });
    }
}

