const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {
    @property(cc.VideoPlayer)
    videoPlayer: cc.VideoPlayer = null;

    @property(cc.Sprite)
    renderSp: cc.Sprite = null;

    mediaRecorder: MediaRecorder = null;
    chunks: any[] = [];

    onLoad() {
        cc.macro.ENABLE_TRANSPARENT_CANVAS = true
        //const video = document.createElement('video');

        this.videoPlayer.node.on('ready-to-play', this.readyToPlayCallback, this);
        this.videoPlayer.node.on('completed', this.CompletedCallback, this);
        this.videoPlayer.node.on('stopped', this.StoppedCallback, this);
        this.videoPlayer.node.on('playing', this.PlayingCallback, this);
    }
    readyToPlayCallback() {
        console.log("ready-to-play")
    }
    CompletedCallback() {
        console.log("completed");
    }
    StoppedCallback() {
        console.log("stopped")
    }
    PlayingCallback() {
        console.log("playing");
    }

    start() {

        const constrains = {
            video: true,
            audio: true
        }
        this.getUserMedia(constrains, stream => {
            console.log("获取设备成功");
            this.mediaRecorder = new MediaRecorder(stream);
            var video = document.querySelector('video');
            // 旧的浏览器可能没有srcObject
            if ("srcObject" in video) {
                video.srcObject = stream;
            } else {
                //避免在新的浏览器中使用它，因为它正在被弃用。
                video.src = window.URL.createObjectURL(stream);
            }
            video.onloadedmetadata = function (e) {
                console.log("loaded....")
                video.play();

                video.style.visibility = "hidden";
            };
        }, (err) => {
            console.log(err.name + ": " + err.message);
        });
    }
    //访问用户媒体设备的兼容方法
    getUserMedia(constraints, success, error) {
        if (navigator.mediaDevices.getUserMedia) {
            //最新的标准API
            navigator.mediaDevices.getUserMedia(constraints).then(success).catch(error);
        } else if (navigator.webkitGetUserMedia) {
            //webkit核心浏览器
            navigator.webkitGetUserMedia(constraints, success, error)
        } else if (navigator.mozGetUserMedia) {
            //firfox浏览器
            navigator.mozGetUserMedia(constraints, success, error);
        } else if (navigator.getUserMedia) {
            //旧版API
            navigator.getUserMedia(constraints, success, error);
        }
    }

    startRecord() {
        console.log("onBtnStartRecord");

        if (!this.mediaRecorder || this.mediaRecorder.state == "recording") return;
        console.log("start record")
        this.mediaRecorder.start();
        this.mediaRecorder.ondataavailable = e => {
            this.chunks.push(e.data)
        };
    }
    showCamera() {
        console.log("onBtnShowCamera");

        var video = document.querySelector('video');
        if (video.style.visibility == "hidden") {
            video.style.visibility = "visible";
        } else {
            video.style.visibility = "hidden";
        }
    }
    takePhoto() {
        console.log("onBtnTakePhoto");

        var canvas = document.getElementById("canvas"),
            //contentHolder = document.getElementById("contentHolder"),
            context = canvas.getContext("2d"),
            video = document.getElementById("video");
        var date = new Date().getTime();
        // 点击，canvas画图
        context.drawImage(video, 0, 0, 300, 300);
        // 获取图片base64链接
        var image = canvas.toDataURL('image/png');
        // 定义一个img
        var img = new Image();
        //设置属性和src
        img.id = "imgBox";
        img.src = image;
        //将图片添加到页面中
        //document.body.appendChild(img);
        //contentHolder.appendChild(img);

        console.log(date);
        this.captureScreenshot(image);
        //console.log(this.dataURLtoFile(image, date + '.png'));
    };
    captureScreenshot(base64) {
        var frame = this.base64ToSpriteFrame(base64, (frame) => {
            this.renderSp.spriteFrame = frame;
        });
        //把图片生成后download到本地
        //var href = base64.replace(/^data:image[^;]*/, "data:image/octet-stream");
        //document.location.href = href;
    }

    stop() {
        if (!this.mediaRecorder || this.mediaRecorder.state == "inactive") return;
        console.log("stop record")
        this.stopRecord().then(videoUrl => {
            console.log("videoUrl:", videoUrl);
            this.videoPlayer.remoteURL = videoUrl as string;
            this.videoPlayer.play();
        })
    }
    stopRecord() {
        console.log("onBtnStopRecord");

        this.mediaRecorder.stop()
        return new Promise(resolve => {
            this.mediaRecorder.onstop = e => {
                console.log("recorder data:", e);
                const blob = new Blob(this.chunks, { type: 'video/ogg; codecs=opus' })
                const audioURL = window.URL.createObjectURL(blob)
                resolve(audioURL)
            }
        })
    }

    //base64转成精灵帧
    base64ToSpriteFrame(base64, callback) {
        var img = new Image();
        img.src = base64;
        img.onload = function () {
            var texture = new cc.Texture2D();
            texture.initWithElement(img);
            texture.handleLoadedTexture();
            console.log("texture data ", texture);
            var newframe = new cc.SpriteFrame(texture);
            if (callback) callback(newframe);
        }
    }
    // base64转文件
    dataURLtoFile(dataurl, filename) {
        var arr = dataurl.split(','),
            mime = arr[0].match(/:(.*?);/)[1],
            bstr = atob(arr[1]),
            n = bstr.length,
            u8arr = new Uint8Array(n);
        while (n--) {
            u8arr[n] = bstr.charCodeAt(n);
        }
        return new File([u8arr], filename, {
            type: mime
        });
    }
}
