
import { _decorator, Component, Node, Label, Vec3, UITransform } from 'cc';
const { ccclass, property } = _decorator;

export enum OperatorType {
    ADD,
    SUB,
    MUL,
    DIV
}

@ccclass('ItemCtrl')
export class ItemCtrl extends Component {

    @property(Label)
    label: Label = null;

    public operatorType: OperatorType = OperatorType.ADD;
    public value: number = 0;
    public isConsumed: boolean = false;

    private speed: number = 300;

    start() {
        // 确保有 Label 组件
        if (!this.label) {
            this.label = this.node.getComponentInChildren(Label);
        }
    }

    init(op: OperatorType, val: number) {
        this.operatorType = op;
        this.value = val;
        this.updateLabel();
    }

    updateLabel() {
        if (!this.label) return;
        let opStr = "";
        switch (this.operatorType) {
            case OperatorType.ADD: opStr = "+"; break;
            case OperatorType.SUB: opStr = "-"; break;
            case OperatorType.MUL: opStr = "x"; break;
            case OperatorType.DIV: opStr = "/"; break;
        }
        this.label.string = `${opStr}${this.value}`;
    }

    update(deltaTime: number) {
        const pos = this.node.position;
        this.node.setPosition(pos.x, pos.y - this.speed * deltaTime, pos.z);

        // 销毁逻辑 (比如 y < -800)
        if (pos.y < -800) {
            this.node.destroy();
        }
    }
}
