
import { _decorator, Component, Node, input, Input, EventTouch, Vec3, find, UITransform } from 'cc';
import { ItemCtrl } from './ItemCtrl';
import { GameCtrl } from './GameCtrl';
const { ccclass, property } = _decorator;

@ccclass('PlayerCtrl')
export class PlayerCtrl extends Component {

    private targetX: number = -150; // 初始在左边
    private moveSpeed: number = 10; // 左右移动速度插值系数
    private itemRoot: Node = null;

    start() {
        console.log("PlayerCtrl start");
        console.log("Player active:", this.node.active);
        console.log("Player position:", this.node.position);
        console.log("Player scale:", this.node.scale);

        input.on(Input.EventType.TOUCH_START, this.onTouchStart, this);
        
        // 查找 ItemRoot
        const gameRoot = find("Canvas/GameRoot");
        if (gameRoot) {
            this.itemRoot = gameRoot.getChildByName("ItemRoot");
        }
        
        // 初始位置
        this.node.setPosition(this.targetX, -200, 0);
    }

    onDestroy() {
        input.off(Input.EventType.TOUCH_START, this.onTouchStart, this);
    }

    onTouchStart(event: EventTouch) {
        // 切换跑道
        if (this.targetX === -150) {
            this.targetX = 150;
        } else {
            this.targetX = -150;
        }
    }

    update(deltaTime: number) {
        // 平滑移动
        const currentPos = this.node.position;
        const newX = currentPos.x + (this.targetX - currentPos.x) * this.moveSpeed * deltaTime;
        this.node.setPosition(newX, currentPos.y, currentPos.z);

        // 碰撞检测
        this.checkCollision();
    }

    checkCollision() {
        if (!this.itemRoot) return;

        const playerPos = this.node.position;
        const children = this.itemRoot.children;

        for (let i = 0; i < children.length; i++) {
            const itemNode = children[i];
            const itemCtrl = itemNode.getComponent(ItemCtrl);
            
            if (itemCtrl && !itemCtrl.isConsumed) {
                const itemPos = itemNode.position;
                
                // 简单的距离检测 (y轴距离小于 50 且 x轴距离小于 50)
                // 假设道具和玩家都在同一层级或者世界坐标转换后比较
                // 这里都在 GameRoot 下，坐标系一致
                
                const distY = Math.abs(playerPos.y - itemPos.y);
                const distX = Math.abs(playerPos.x - itemPos.x);

                if (distY < 60 && distX < 60) {
                    // 发生碰撞
                    itemCtrl.isConsumed = true;
                    itemNode.destroy(); // 或者播放特效后销毁
                    
                    // 通知 GameCtrl
                    const gameCtrl = find("Canvas/GameManager").getComponent(GameCtrl);
                    if (gameCtrl) {
                        gameCtrl.onItemHit(itemCtrl.operatorType, itemCtrl.value);
                    }
                }
            }
        }
    }
}
