/**
 @class ZRenderRoot
 @author YI ZHANG
 @date 2022/7/11
 @desc
 **/
import * as cc from "cc";
import { JSB } from "cc/env";
const {ccclass, property} = cc._decorator;
if(!JSB){
    let oldFunc2 = cc.UIOpacity.prototype.onEnable;
    cc.UIOpacity.prototype.onEnable = function (){
        oldFunc2.call(this);
        // @ts-ignore
        this.node._uiProps.localOpacityEx = this._opacity / 255;
    }
    let oldFunc3 = cc.UIOpacity.prototype.onEnable;
    cc.UIOpacity.prototype.onDisable = function (){
        oldFunc3.call(this);
        // @ts-ignore
        this.node._uiProps.localOpacityEx = 1;
    }
    Object.defineProperty(cc.UIOpacity.prototype,"opacity",{
        get(): any {
            return this._opacity;
        },
        set(value: any) {
            if (this._opacity === value) {
                return;
            }
            value = Math.max(Math.min(value, 255),0);
            this._opacity = value;
            let opacity = value / 255;
            this.node._uiProps.localOpacity = opacity;
            this.node._uiProps.localOpacityEx = opacity;
        }
    })
}

@ccclass("ZRenderRoot")
export default class ZRenderRoot extends cc.Component{
    @property(cc.Node)
    renderNode : cc.Node = null!;
    @property(cc.CCInteger)
    layer = 1;
    v3_1 = cc.v3();
    v3_2 = cc.v3();
    childrenList : cc.Node[] = [];
    walkIndex: number = 0;
    static clamp(value : number,min : number, max :number){
        return value > max ? max : (value < min ? min : value);
    }
    protected onLoad() {
        if(JSB){
            this.renderNode.name = "ZRenderRoot"
            this.renderNode.layer = 1 << this.layer;
            return;
        }
        let self = this;
        Object.defineProperty(this.node,"children",{
            get(): any {
                return self.childrenList;
            }
        });
    }

    protected onEnable() {
        if(JSB){
            return;
        }
        this.renderNode.layer = 0;
        this.renderNode._static = true;

        cc.director.on(cc.Director.EVENT_BEFORE_DRAW,()=>{//发出渲染前事件供自定义组件更新脏视图
            this.getChildrenList();
        },this);
        cc.director.on(cc.Director.EVENT_AFTER_DRAW,()=>{//发出渲染前事件供自定义组件更新脏视图
            this.childrenList.length = 0;
        },this);
    }

    static forEachNode(node : cc.Node,fn : (node : cc.Node)=>boolean | void){
        if(fn(node)){
            return true;
        }
        let children = node.children;
        for(let i = 0;i < children.length;++i){
            if(this.forEachNode(children[i],fn)){
                return true;
            }
        }
        return false;
    }

    protected onDisable() {
        if(JSB){
            return;
        }
        this.renderNode._static = false;
        ZRenderRoot.forEachNode(this.renderNode,node => {
            node._static = false;
        })
        this.childrenList.length = 0;
        cc.director.targetOff(this);
    }

    getChildrenList(){
        this.childrenList.length = 0;
        this.walkIndex = 0;
        this.walk(this.renderNode,1);
        let list = this.childrenList;
        let length = list.length;
        let layer = 1 << this.layer;
        let index = 0;
        for(let i = 0;i < length;++i){
            let node = this.childrenList[i];
            // @ts-ignore
            node._indexEx = Math.round(-node._pos.z * 1000);
            // @ts-ignore
            node._indexEx2 = index;
            node._static = true;
            if(node.layer != layer){
                node.layer = layer;
            }
        }
        this.childrenList.sort((a,b)=>{
            // @ts-ignore
            return a._indexEx - b._indexEx || a._indexEx2 - b._indexEx2;
        });

    }
    walk(node : cc.Node,opacity : number){
        let uiProps = node._uiProps;
        // @ts-ignore
        let localOpacity = uiProps.localOpacityEx === undefined ? 1 : uiProps.localOpacityEx;
        // @ts-ignore
        opacity = opacity * localOpacity ;
        uiProps.localOpacity = opacity;
        let comp = uiProps.uiComp as cc.Sprite;
        if(opacity > 0){
            if(comp && comp.enabled){
                this.childrenList.push(node);
                // let frame =  (comp as cc.Sprite).spriteFrame;
                //
                // // @ts-ignore
                // if(comp && frame){
                //     // @ts-ignore
                //     let oldTexIdx = comp._curTexIdx;
                //     // @ts-ignore
                //     let id = DynamicAtlasRoot.getTextureId(frame.texture);
                //     if(comp instanceof cc.Label){
                //         if(oldTexIdx == undefined){
                //             // @ts-ignore
                //             let func = comp._assembler.fillBuffers;
                //             // @ts-ignore
                //             comp._assembler.fillBuffers = function (...args){
                //                 func.call(this,...args);
                //                 changeVb.call(args[0]);
                //             }
                //         }
                //     }else {
                //         changeVb.call(comp);
                //     }
                //     // @ts-ignore
                //     comp._curTexIdx = DynamicAtlasRoot.curNum;
                //     if(id < 1){
                //         if(comp.customMaterial != DynamicAtlasRoot.originMaterial){
                //             comp.customMaterial = DynamicAtlasRoot.originMaterial;
                //         }
                //         return;
                //     }
                //     if(comp.customMaterial != DynamicAtlasRoot.curMaterial){
                //         comp.customMaterial = DynamicAtlasRoot.curMaterial;
                //     }
                // }
            }
            let  children = node.children;
            let length = children.length;
            for(let i = 0;i < length;++i){
                let node = children[i];
                node.active && this.walk(node,opacity);
            }
        }
    }

}
// let changeVb = function (){
//     // @ts-ignore
//     if(this._renderData && this._renderData.chunk && this.spriteFrame){
//         // @ts-ignore
//         let id = DynamicAtlasRoot.getTextureId(this.spriteFrame.texture);
//         // @ts-ignore
//         let vb = this._renderData.chunk.vb;
//         for(let i = 2;i < vb.length;i += 9){
//             vb[i] = id;
//         }
//     }
// }

