// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class Map extends cc.Component {

    @property(cc.TiledMap)
    map:cc.TiledMap;
    // LIFE-CYCLE CALLBACKS:

    onLoad () {
        let layer = this.map.getLayer("wall")
        let t_size = this.map.getTileSize();
        let l_size=layer.getLayerSize();
        console.log(l_size)

        for(let i=0;i<l_size.width;i++){
            for(let l=0;l<l_size.height;l++){
                let tiled = layer.getTiledTileAt(i,l,true);
                if(tiled.gid!=0){
                    tiled.node.group="wall"
                    let body = tiled.node.addComponent(cc.RigidBody)
                    body.type=cc.RigidBodyType.Static;
                    let collider = tiled.node.addComponent(cc.PhysicsBoxCollider)
                    collider.offset=cc.v2(t_size.width/2,t_size.height/2)
                    collider.size.height=16;
                    collider.size.width=16;
                    collider.apply();
                }
            }
        }
    }

    start () {

    }

    // update (dt) {}
}
