// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class PlayerController extends cc.Component {

    rig:cc.RigidBody=null

    // LIFE-CYCLE CALLBACKS:

    onLoad () {
        let p = cc.director.getPhysicsManager();
        p.enabled=true;
        p.debugDrawFlags=1;
        p.gravity=cc.v2(0,0);

        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN,this.onKeyDown,this)
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP,this.onKeyUp,this)

        this.rig=this.node.getComponent(cc.RigidBody);
    }

    start () {

    }

    onKeyDown(event){
        let self = this;
        switch(event.keyCode){
            case cc.macro.KEY.w:
                self.rig.linearVelocity=cc.v2(0,30)
                break;
            case cc.macro.KEY.a:
                self.rig.linearVelocity=cc.v2(-30,0)
                break;
            case cc.macro.KEY.s:
                self.rig.linearVelocity=cc.v2(0,-30)
                break;
            case cc.macro.KEY.d:
                self.rig.linearVelocity=cc.v2(30,0)
                break;
        }
    }

    onKeyUp(event){
        let self = this;
    }

    update (dt) {
        
    }
}
