/*
 * @Author: mikey.ni 
 * @Date: 2018-5-14 10:24:46 
 * @Last Modified by: mikey.ni
 * @Last Modified time: 2019-01-14 10:41:20
 * @mailbox 769228622@qq.com
 */
const { ccclass } = cc._decorator;
@ccclass
export class CalendarView extends cc.Component {
    private contenArr: Array<cc.Node> = []
    private lblYear: cc.Node = null;  //年月日显示
    private conten: cc.Node = null;
    private layblue: cc.Node = null;
    private lblLastMonth: cc.Label = null; //上个月
    private lblNextMonth: cc.Label = null; //下个月
    private currentMonth: number = 0; // 当前余额
    private newYear: number = 0;
    private newMonth: number = 0;
    private defauleDayTag: number = null;
    public lblCurrentTime: cc.Label = null; //当前选择时间文本 
    public nodeDayTime: cc.Node = null //今天时间

    /** 文本色值 */
    private get setectColor(): cc.Color { return new cc.Color().fromHEX("#FFF073") };
    private get defaultColor(): cc.Color { return new cc.Color().fromHEX("#FFF6E6") };
    private get disableColor(): cc.Color { return new cc.Color().fromHEX("#8F8F8F") };

    //限制天数查询
    public limitDayNum: number = 30;
    /**
     * 时间工具
     */
    private uiltTime: UtilTime;

    private init() {
        this.uiltTime = new UtilTime();

        this.conten = this.sprBgNode.getChildByName("conten");
        this.lblYear = this.sprBgNode.getChildByName("lblYear");
        this.layblue = this.sprBgNode.getChildByName("layblue");
        this.nodeDayTime = this.sprBgNode.getChildByName("lblDayTime");

        let lblLastMonthNode: cc.Node = this.sprBgNode.getChildByName("lblLasttMonth");
        let lblNextMonthNode: cc.Node = this.sprBgNode.getChildByName("lblNextMonth");

        this.lblLastMonth = lblLastMonthNode.getComponent(cc.Label);
        this.lblNextMonth = lblNextMonthNode.getComponent(cc.Label);
        this.contenArr = this.conten.children;
        let lbl: cc.Label = null;

        for (let i = 0; i < this.contenArr.length; i++) {
            lbl = this.contenArr[i].getComponent(cc.Label);
            if (lbl) {
                lbl.overflow = cc.Label.Overflow.CLAMP;
                lbl.node.setContentSize(40, 40);
            }
        }
    }
    onLoad() {
        this.init();
        this.addEventNodeFun();
        // this.node.active = false;
    }

    onEnable() {
        this.initViewFun();
    }

    onDisable() {

    }
    onDestroy() {
        this.removeEventNodeFun();

    }

    private get sprBgNode(): cc.Node {
        return this.node.getChildByName("sprBg");
    }

    private addEventNodeFun() {   //添加监听事件
        let self = this
        this.contenArr = this.conten.children;
        for (let i = 0; i < this.contenArr.length; i++) {
            this.contenArr[i].on(cc.Node.EventType.TOUCH_START, this.upEventReceiveFun, this);
            this.contenArr[i].on(cc.Node.EventType.TOUCH_END, this.upLayblueFun, this);
        }
        this.node.getChildByName("sprBg").on(cc.Node.EventType.TOUCH_START, function (event) {
            event.stopPropagation();
        }, this);
        this.node.getChildByName("eventBg").on(cc.Node.EventType.TOUCH_START, function (event) {
            event.stopPropagation();
            self.hide();
        }, this);
        this.nodeDayTime.on(cc.Node.EventType.TOUCH_END, this.onUpdateDayTime.bind(this));
    }
    private removeEventNodeFun() {
        this.contenArr = this.conten.children;

        if (!this.node.isValid) return;
        // for (let i = 0; i < this.contenArr.length; i++) {
        //     this.contenArr[i].off(cc.Node.EventType.TOUCH_START, this.upEventReceiveFun, this)
        //     this.contenArr[i].off(cc.Node.EventType.TOUCH_START, this.upLayblueFun, this)
        // }
        //  this.nodeDayTime.off(cc.Node.EventType.TOUCH_END, this.onUpdateDayTime.bind(this));
    }

    private onUpdateDayTime() {

        this.initViewFun();
    }

    private initViewCalendar(start: number, end: number, dcurrent: number = -1) {   //列表初始化

        let startS: number = (start == 7) ? 0 : start;//星期
        let k: number = 0;//当月天数；
        let upObj: any = this.getUpMonthMaxDay();
        let upDay: number = upObj.end - startS;//上个月补位天数
        let downDay: number = 0; //下个月补位天数
        for (let i: number = 0; i < this.contenArr.length; i++) {
            this.contenArr[i].getChildByName("lblYinli").getComponent(cc.Label).string = "";
            if (startS <= i && end + startS > i) {
                ++k;
                this.contenArr[i].name = k + "";
                if (k == dcurrent) {
                    this.defauleDayTag = i;
                }
                this.contenArr[i].getComponent(cc.Label).string = k.toString();
                // this.contenArr[i].getChildByName("lblYinli").getComponent(cc.Label).string = LunarDate.GetLunarDay(this.newYear, this.newMonth, k)

            } else {
                // this.contenArr[i].getComponent(cc.Label).string = "";    // !根据需求改变 
                if (i < startS) {       //上个月的补空位
                    ++upDay;
                    this.contenArr[i].name = (100 + upDay) + "";
                    this.contenArr[i].getComponent(cc.Label).string = upDay.toString();
                } else if (i >= end + startS) {  //下个月补空位
                    ++downDay;
                    this.contenArr[i].getComponent(cc.Label).string = downDay.toString();
                    this.contenArr[i].name = (200 + downDay) + "";
                }
            }
            this.setlblNodeColor(this.contenArr[i]);
        }
    }

    private setlblNodeColor(node: cc.Node): void {
        if (this.limitDayNum > 0) {
            let time: number = this.uiltTime.formatTimeStamp(this.getTimeFormat(node.name));
            let newTime: number = this.uiltTime.get1DayLastDate(new Date().getTime(), -this.limitDayNum);
            if (time >= newTime && time - newTime <= (this.limitDayNum + 1) * 24 * 3600 * 1000 - 1) {
                node.color = this.defaultColor;
            } else {
                node.color = this.disableColor;
            }
        } else {
            node.color = this.defaultColor;
        }
    }

    private initViewFun() { //初始化
        let date: Date = new Date()
        let severTime: string = this.uiltTime.formatYMD1(date);
        this.currentMonth = date.getMonth() + 1;
        cc.log(this.currentMonth)
        this.updateMonth();
        this.lblYear.getComponent(cc.Label).string = severTime;
        let str = severTime.split("/")
        this.newYear = Number(str[0]);
        this.newMonth = Number(str[1]);
        let minAndMax: any = this.getTimeDataFun(this.newYear, this.newMonth)
        this.initViewCalendar(minAndMax.start, minAndMax.end, Number(str[2]));
        this.setLayblueState(this.contenArr[this.defauleDayTag]);
        this.lblYear.getComponent(cc.Label).string = this.uiltTime.formatYMD2(date);
        if (this.lblCurrentTime) {
            this.lblCurrentTime.string = this.uiltTime.formatYMD2(date);;
        }
    }

    /** 设置选中块  */
    private _curSelectTarget: cc.Node;
    private setLayblueState(target: cc.Node): void {
        if (target) {
            if (this._curSelectTarget) {
                this._curSelectTarget.color = this.defaultColor;
            }
            this._curSelectTarget = target;
            target.color = this.setectColor;
            let nodeWordPos = this.conten.convertToWorldSpaceAR(target.getPosition());
            let myParentSpacePosition = this.sprBgNode.convertToNodeSpaceAR(nodeWordPos);
            this.layblue.setPosition(myParentSpacePosition);
        }
        this.layblue.active = target ? true : false;
    }

    private updateFun() {   //更新
        this.lblYear.getComponent(cc.Label).string = this.newYear + "/" + this.newMonth;
        let minAndMax: any = this.getTimeDataFun(this.newYear, this.newMonth)
        this.initViewCalendar(minAndMax.start, minAndMax.end)
    }

    private upLayblueFun(event) {
        if (!event.target.getComponent(cc.Label).string) return;
        if (event.target.color.equals(this.disableColor)) return;
        this.setLayblueState(event.target);
    }

    private upEventReceiveFun(event: cc.Event.EventTouch) {    //点击事件触发
        if (!event.target.getComponent(cc.Label).string) return;
        if (event.target.color.equals(this.disableColor)) return;
        let YearMD: string = "";
        YearMD = this.getTimeFormat(event.target.name);
        this.lblYear.getComponent(cc.Label).string = YearMD;
        cc.log("事件=================", YearMD);
        if (this.lblCurrentTime) {
            this.lblCurrentTime.string = YearMD;
        }
    }

    private getTimeFormat(name: string): string {
        let tag: number = Number(name);
        let yearMonth: any = { yaer: 0, month: 0 };
        let day: number = 0;
        let YearMD: string = "";
        if (tag > 200) {
            day = Math.abs(tag - 200);
            yearMonth = this.downYaerMonthWayFun();
        } else if (tag > 100) {
            day = Math.abs(tag - 100);
            yearMonth = this.upYaerMonthWayFun();
        } else {
            day = tag;
            yearMonth.yaer = this.newYear;
            yearMonth.month = this.newMonth;
        }
        let monthStr: string = (yearMonth.month < 10 ? "0" : "") + yearMonth.month;
        let dayStr: string = (day < 10 ? "0" : "") + day;
        YearMD = yearMonth.yaer + "-" + monthStr + "-" + dayStr;
        return YearMD
    }

    private leftBtnFun() {
        if (this.reduceDateFun()) {
            this.setLayblueState(null);
            this.updateFun()
        } else {
            alert("超出日期范围")
        }
    }
    private rigthBtnFun() {
        this.setLayblueState(null);
        this.addDateFun();
        this.updateFun();
    }
    private reduceDateFun(): boolean {
        if (this.newMonth - 1 > 0) {
            this.newMonth -= 1;
            this.currentMonth = this.newMonth;
            this.updateMonth();
            return true
        } else {
            if (this.newYear - 1 > 1980) {
                this.newYear -= 1;
                this.newMonth = 12;
                this.currentMonth = this.newMonth;
                this.updateMonth();
                return true
            } else {
                return false
            }
        }
    }

    private addDateFun() {

        if (this.newMonth + 1 < 13) {
            this.newMonth += 1;
            this.currentMonth = this.newMonth;
            this.updateMonth();
        } else {
            this.newYear += 1;
            this.newMonth = 1
            this.currentMonth = this.newMonth;
            this.updateMonth();
            // if( this.newYear + 1 < 2020){
            //     this.newYear+=1;
            //     this.newMonth = 1
            // }else{
            //  //cc.log("addDateFun=====提示==", this.newYear)
            // }
        }
    }



    private updateMonth() {
        if (this.currentMonth == 12) {

            this.lblNextMonth.string = 1 + "月";

            this.lblLastMonth.string = (this.currentMonth - 1) + "月";

        } else if (this.currentMonth == 1) {

            this.lblNextMonth.string = (this.currentMonth + 1) + "月";

            this.lblLastMonth.string = 12 + "月";
        } else {

            this.lblNextMonth.string = (this.currentMonth + 1) + "月";

            this.lblLastMonth.string = (this.currentMonth - 1) + "月";
        }

    }

    private getTimeDataFun(yaer: number, month: number): any {
        let temp: Date = new Date(yaer, month, 0);
        let max: number = temp.getDate()
        temp.setDate(1)
        let min: number = temp.getDay()
        let bol: boolean = (yaer % 4 == 0 && yaer % 100 != 0) || yaer % 400 == 0;
        if (bol) {
            if (month == 2) {
                max = 29;
            }
        } else {
            if (month == 2) {
                max = 28;
            }
        }
        return { start: min, end: max }
    }

    private getUpMonthMaxDay(): any {
        let upYearMonth: any = {};
        upYearMonth = this.upYaerMonthWayFun()
        return this.getTimeDataFun(upYearMonth.yaer, upYearMonth.month)
    }

    private upYaerMonthWayFun(): object {
        let upYear: number = 0;
        let upMonth: number = 0
        if (this.newMonth == 1) {
            upYear = this.newYear - 1
            upMonth = 12;
        } else {
            upYear = this.newYear;
            upMonth = this.newMonth - 1;
        }
        return { yaer: upYear, month: upMonth }
    }
    private downYaerMonthWayFun(): object {

        let downYear: number = 0;
        let downMonth: number = 0
        if (this.newMonth == 12) {
            downYear = this.newYear + 1;
            downMonth = 1;
        } else {
            downYear = this.newYear;
            downMonth = this.newMonth + 1;
        }
        return { yaer: downYear, month: downMonth }
    }
    public show(cur:cc.Label) {
        this.lblCurrentTime = cur;
        if (!this.node.active) {
            this.node.active = true;
            this.changeIconRotation(true);
        }
    }
    public hide() {
        if (this.node.active) {
            this.node.active = false;
            this.changeIconRotation(false);
        }
    }

    public changeIconRotation(bool: boolean): void {
        let parent: cc.Node = this.lblCurrentTime.node.parent;
        let rotation: number = bool ? 180 : 0;
        if ("lblStartTime" == this.lblCurrentTime.node.name) {
            parent.getChildByName("bg_1").children[0].rotation = rotation;
        } else {
            parent.getChildByName("bg_2").children[0].rotation = rotation;
        }
    }
}
class UtilTime {
    /**
     * 年/月/日（例：2012/12/12）
     */
    public formatYMD1(date: Date): string {
        var time: string = date.getFullYear() + "/"
            + (date.getMonth() + 1) + "/"
            + date.getDate();
        return time;
    }

    /**
     * 年-月-日（例：2012-12-12）
     */
    public formatYMD2(date: Date): string {
        var year: string = date.getFullYear().toString();
        var month: string = ((date.getMonth() + 1 < 10) ? "0" : "") + (date.getMonth() + 1);
        var day: string = ((date.getDate() < 10) ? "0" : "") + date.getDate();
        return year + "-" + month + "-" + day;
    }

    /**
     *转成时间戳 年-月-日  如 2018-2-30
     * @
     * @param {string} formatTime
     * @memberof UtilTime
     */
    public formatTimeStamp(formatTime: string): number {
        let date: Date = new Date(formatTime)
        let time: number = date.getTime();
        return time;
    }

    /**
     * 获取时间戳 23：59：59 的 新的时间戳
     * @
     * @param {number} time
     * @param {number} [lastDay=1]
     * @returns {number}
     * @memberof UtilTime
     */
    public get1DayLastDate(time: number, lastDay: number = 1): number {
        let date: Date = new Date(time);
        date.setHours(0);
        date.setMinutes(0);
        date.setSeconds(0);
        date.setMilliseconds(0);
        let newTime: number = date.getTime() + (lastDay * 24 * 3600 * 1000) - 1;
        return newTime;
    }


}
// let LunarDate = {
//     madd: new Array(0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334),
//     HsString: '甲乙丙丁戊己庚辛壬癸',
//     EbString: '子丑寅卯辰巳午未申酉戌亥',
//     NumString: "一二三四五六七八九十",
//     MonString: "正二三四五六七八九十冬腊",
//     CalendarData: new Array(0xA4B, 0x5164B, 0x6A5, 0x6D4, 0x415B5, 0x2B6,
//         0x957, 0x2092F, 0x497, 0x60C96, 0xD4A, 0xEA5, 0x50DA9, 0x5AD, 0x2B6,
//         0x3126E, 0x92E, 0x7192D, 0xC95, 0xD4A, 0x61B4A, 0xB55, 0x56A, 0x4155B,
//         0x25D, 0x92D, 0x2192B, 0xA95, 0x71695, 0x6CA, 0xB55, 0x50AB5, 0x4DA,
//         0xA5B, 0x30A57, 0x52B, 0x8152A, 0xE95, 0x6AA, 0x615AA, 0xAB5, 0x4B6,
//         0x414AE, 0xA57, 0x526, 0x31D26, 0xD95, 0x70B55, 0x56A, 0x96D, 0x5095D,
//         0x4AD, 0xA4D, 0x41A4D, 0xD25, 0x81AA5, 0xB54, 0xB6A, 0x612DA, 0x95B, 0x49B,
//         0x41497, 0xA4B, 0xA164B, 0x6A5, 0x6D4, 0x615B4, 0xAB6, 0x957, 0x5092F, 0x497,
//         0x64B, 0x30D4A, 0xEA5, 0x80D65, 0x5AC, 0xAB6, 0x5126D, 0x92E, 0xC96, 0x41A95, 0xD4A,
//         0xDA5, 0x20B55, 0x56A, 0x7155B, 0x25D, 0x92D, 0x5192B, 0xA95, 0xB4A, 0x416AA, 0xAD5,
//         0x90AB5, 0x4BA, 0xA5B, 0x60A57, 0x52B, 0xA93, 0x40E95),
//     Year: null,
//     Month: null,
//     Day: null,
//     TheDate: null,
//     GetBit: function (m, n) {
//         return (m >> n) & 1;
//     },
//     e2c: function () {
//         this.TheDate = (arguments.length != 3) ? new Date() : new Date(arguments[0], arguments[1], arguments[2]);
//         var total, m, n, k;
//         var isEnd = false;
//         var tmp = this.TheDate.getFullYear();
//         total = (tmp - 1921) * 365 + Math.floor((tmp - 1921) / 4) + this.madd[this.TheDate.getMonth()] + this.TheDate.getDate() - 38;
//         if (this.TheDate.getYear() % 4 == 0 && this.TheDate.getMonth() > 1) {
//             total++;
//         }
//         for (m = 0; ; m++) {
//             k = (this.CalendarData[m] < 0xfff) ? 11 : 12;
//             for (n = k; n >= 0; n--) {
//                 if (total <= 29 + this.GetBit(this.CalendarData[m], n)) {
//                     isEnd = true;
//                     break;
//                 }
//                 total = total - 29 - this.GetBit(this.CalendarData[m], n);
//             }
//             if (isEnd)
//                 break;
//         }
//         this.Year = 1921 + m;
//         this.Month = k - n + 1;
//         this.Day = total;
//         if (k == 12) {
//             if (this.Month == Math.floor(this.CalendarData[m] / 0x10000) + 1) {
//                 this.Month = 1 - this.Month;
//             }
//             if (this.Month > Math.floor(this.CalendarData[m] / 0x10000) + 1) {
//                 this.Month--;
//             }
//         }
//     },
//     GetcDateString: function () {
//         var tmp = "";
//         // tmp += this.HsString.charAt((this.Year - 4) % 10);
//         // tmp += this.EbString.charAt((this.Year - 4) % 12);
//         // tmp += "年 ";
//         let  sd =""
//         let monthStr = ""
//         let haoStr = ""

//         if (this.Month < 1) {
//             // tmp += "(闰)";
//             monthStr = this.MonString.charAt(-this.Month - 1);
//         } else {
//             monthStr = this.MonString.charAt(this.Month - 1);
//         }

//         // tmp += "月";
//         haoStr = (this.Day < 11) ? "初" : ((this.Day < 20) ? "十" : ((this.Day < 30) ? "廿" : "三十"));
//         if (this.Day % 10 != 0 || this.Day == 10) {
//             //tmp += this.NumString.charAt((this.Day - 1) % 10);
//             // cc.log("this.Day==",this.Day)
//             sd = this.NumString.charAt((this.Day - 1) % 10);    
//             haoStr+=sd
//         }
//         if(haoStr==="初一"){
//             tmp += (monthStr+"月")
//         }else{
//             tmp += haoStr
//         }
//         return tmp;
//     },
//     GetLunarDay: function (solarYear, solarMonth, solarDay) {
//         if (solarYear < 1921|| solarYear > 2020 ) {//
//             return "";
//         } else {
//             solarMonth = (parseInt(solarMonth) > 0) ? (solarMonth - 1) : 11;
//             this.e2c(solarYear, solarMonth, solarDay);
//             return this.GetcDateString();
//         }
//     }
// };
