/***
 *
 *   █████▒█    ██  ▄████▄   ██ ▄█▀       ██████╗ ██╗   ██╗ ██████╗
 * ▓██   ▒ ██  ▓██▒▒██▀ ▀█   ██▄█▒        ██╔══██╗██║   ██║██╔════╝
 * ▒████ ░▓██  ▒██░▒▓█    ▄ ▓███▄░        ██████╔╝██║   ██║██║  ███╗
 * ░▓█▒  ░▓▓█  ░██░▒▓▓▄ ▄██▒▓██ █▄        ██╔══██╗██║   ██║██║   ██║
 * ░▒█░   ▒▒█████▓ ▒ ▓███▀ ░▒██▒ █▄       ██████╔╝╚██████╔╝╚██████╔╝
 *  ▒ ░   ░▒▓▒ ▒ ▒ ░ ░▒ ▒  ░▒ ▒▒ ▓▒       ╚═════╝  ╚═════╝  ╚═════╝
 *  ░     ░░▒░ ░ ░   ░  ▒   ░ ░▒ ▒░
 *  ░ ░    ░░░ ░ ░ ░        ░ ░░ ░
 *           ░     ░ ░      ░  ░
 *
 *
 *	本代码作者：山水有相逢
 *	《》
 */

import { Main_M } from "./mainUI/m/Main_M";

const {ccclass, property} = cc._decorator;

@ccclass
export class AllUIMgr extends cc.Component {
    public static Instance: AllUIMgr = null;

    @property({type:[cc.Prefab],tooltip:"关卡预制体列表"})
    public lvPrefabs:cc.Prefab[] = [];


    private _gameRoot:cc.Node = null;//游戏关卡根节点
    private _mainRoot:cc.Node = null;//游戏界面根节点

    onLoad() {
        if (AllUIMgr.Instance === null) {
            AllUIMgr.Instance = this;
            cc.log("STATE:[AllUIMgr.ts]      界面UI管理系统初始化完成！");
        }
        else {
            this.destroy();
            return;
        }

        this._gameRoot = cc.find("Canvas/gameRoot");
        this._mainRoot = cc.find("Canvas/mainRoot");

        this.goToMainUI();
    }
    
    
    /**创建当前关卡 */
    public createNowLv(){
        cc.log("创建当前关卡");
        let lv:number = Main_M.instent.lv;

        this._gameRoot.removeAllChildren(true);
        this._gameRoot.addChild(cc.instantiate(this.lvPrefabs[lv]));
    }

    /**到游戏界面 */
    public goToGameUI(){
        this._mainRoot.children.forEach((value: cc.Node)=>{
            value.active = false;
        })
    }

    /**到主界面 */
    public goToMainUI(){
        this._mainRoot.children.forEach((value: cc.Node)=>{
            value.active = value.name == "Main";
        })
    }

    /**到胜利界面 */
    public goToWinUI(){
        this._mainRoot.children.forEach((value: cc.Node)=>{
            value.active = value.name == "Win";
        })
    }

    /**到失败界面 */
    private goToLoseUI(){
        this._mainRoot.children.forEach((value: cc.Node)=>{
            value.active = value.name == "Lose";
        })
    }
}
