


const { ccclass, property } = cc._decorator;


/***
 *
 *   █████▒█    ██  ▄████▄   ██ ▄█▀       ██████╗ ██╗   ██╗ ██████╗
 * ▓██   ▒ ██  ▓██▒▒██▀ ▀█   ██▄█▒        ██╔══██╗██║   ██║██╔════╝
 * ▒████ ░▓██  ▒██░▒▓█    ▄ ▓███▄░        ██████╔╝██║   ██║██║  ███╗
 * ░▓█▒  ░▓▓█  ░██░▒▓▓▄ ▄██▒▓██ █▄        ██╔══██╗██║   ██║██║   ██║
 * ░▒█░   ▒▒█████▓ ▒ ▓███▀ ░▒██▒ █▄       ██████╔╝╚██████╔╝╚██████╔╝
 *  ▒ ░   ░▒▓▒ ▒ ▒ ░ ░▒ ▒  ░▒ ▒▒ ▓▒       ╚═════╝  ╚═════╝  ╚═════╝
 *  ░     ░░▒░ ░ ░   ░  ▒   ░ ░▒ ▒░
 *  ░ ░    ░░░ ░ ░ ░        ░ ░░ ░
 *           ░     ░ ░      ░  ░
 *
 *
 *	本代码作者：山水有相逢
 *	《事件管理器》
 */
@ccclass
export default class EventMgr extends cc.Component {
    public static Instance: EventMgr = null;

    private events_map = {};

    onLoad() {
        if (EventMgr.Instance === null) {
            EventMgr.Instance = this;
            cc.log("STATE:[EventMgr.ts]      事件管理系统初始化完成！");
        }
        else {
            this.destroy();
            return;
        }
    }

    //#region 事件名

    /**数据更新事件 */
    public dataUpdateEvent = {

    }

    //#endregion

    //#region 系统事件


    public Game_Event = {
        /**开始游戏 */
        beginGame:"beginGame",
    }



    //#endregion

    //#region 事件函数

    /**
     * 添加一个事件的监听
     * @param event_name    事件名
     * @param caller        订阅对象 this 
     * @param func          回调函数
     */
    public add_event_listenner(event_name: string, caller: any, func: Function) {
        if (!!!this.events_map[event_name]) {
            this.events_map[event_name] = [];
        }

        let event_queue = this.events_map[event_name];
        event_queue.push({
            caller: caller,
            func: func
        });
    }

    /**
     * 移除一个事件的监听
     * @param event_name    事件名
     * @param caller        订阅对象 this 
     * @param func          回调函数
     */
    public remove_event_listenner(event_name: string, caller, func: Function) {
        if (!!!this.events_map[event_name]) {
            return;
        }

        let event_queue = this.events_map[event_name];
        for (let i = 0; i < event_queue.length; i++) {
            let obj = event_queue[i];
            if (obj.caller == caller && obj.func == func) {
                event_queue.splice(i, 1);
                break;
            }
        }

        if (event_queue.length <= 0) {
            this.events_map[event_name] = null;
        }
    }

    /**
     * 发送事件
     * @param event_name    事件名
     * @param udata         传输的数据对象
     */
    public dispatch_event(event_name: string, udata: any) {

        if (!this.events_map[event_name]) {
            return;
        }

        let event_queue = this.events_map[event_name];
        for (let i = 0; i < event_queue.length; i++) {
            let obj = event_queue[i];
            obj.func.call(obj.caller, event_name, udata);
        }
    }

    //#endregion
}
