/***
 *
 *   █████▒█    ██  ▄████▄   ██ ▄█▀       ██████╗ ██╗   ██╗ ██████╗
 * ▓██   ▒ ██  ▓██▒▒██▀ ▀█   ██▄█▒        ██╔══██╗██║   ██║██╔════╝
 * ▒████ ░▓██  ▒██░▒▓█    ▄ ▓███▄░        ██████╔╝██║   ██║██║  ███╗
 * ░▓█▒  ░▓▓█  ░██░▒▓▓▄ ▄██▒▓██ █▄        ██╔══██╗██║   ██║██║   ██║
 * ░▒█░   ▒▒█████▓ ▒ ▓███▀ ░▒██▒ █▄       ██████╔╝╚██████╔╝╚██████╔╝
 *  ▒ ░   ░▒▓▒ ▒ ▒ ░ ░▒ ▒  ░▒ ▒▒ ▓▒       ╚═════╝  ╚═════╝  ╚═════╝
 *  ░     ░░▒░ ░ ░   ░  ▒   ░ ░▒ ▒░
 *  ░ ░    ░░░ ░ ░ ░        ░ ░░ ░
 *           ░     ░ ░      ░  ░
 *
 *
 *	本代码作者：山水有相逢
 *	《》
 */

import EventMgr from "../../EventMgr";

const { ccclass, property } = cc._decorator;

@ccclass
export class Game01_Ctrl extends cc.Component {

    @property(cc.TiledMap)
    public tiledMap: cc.TiledMap = null;

    onLoad() {

        // this._addFloorBoxCillider();
        setTimeout(() => {
            this.node.setPosition(cc.v2());
            this.node.getChildByName("map").setPosition(cc.v2(-this.node.parent.width / 2));

            this._addFloorBoxCillider();

            
        }, 1);
    }


    protected onEnable(): void {
        EventMgr.Instance.add_event_listenner(EventMgr.Instance.Game_Event.beginGame, this, this._beginGame);
    }

    protected onDisable(): void {
        EventMgr.Instance.remove_event_listenner(EventMgr.Instance.Game_Event.beginGame, this, this._beginGame);
    }

    private _addFloorBoxCillider() {
        //根据图层名获取图层
        let layer: cc.TiledLayer = this.tiledMap.getLayer("land");
        
        let mapData: number[][] = this._getAllGid(layer);
        let offset:cc.Vec2 = cc.v2(8,-this.tiledMap.node.height/2+8);
        cc.log("offset",offset);
        for (let x = 0; x < mapData.length; x++) {
            for (let y = 0; y < mapData[0].length; y++) {
                if (mapData[x][y] != 0) {
                    let pos: cc.Vec2 = layer.getPositionAt(cc.v2(x, y));
                    let boxColloder:cc.PhysicsBoxCollider = this.tiledMap.node.addComponent(cc.PhysicsBoxCollider);
                    boxColloder.size = this.tiledMap.getTileSize();
                    boxColloder.offset = pos.add(offset);
                    boxColloder.apply();
                }
            }
        }

    }

    private _getAllGid(layer: cc.TiledLayer): number[][] {
        //获取图层的行列数
        let layerSize: cc.Size = layer.getLayerSize();
        let width = layerSize.width;
        let height = layerSize.height;
        console.log(layerSize);  // size(width:40, height:30)
        //获取图层的gid
        let mapData = [];
        for (let x = 0; x < width; x++) {
            mapData[x] = [];
            for (let y = 0; y < height; y++) {
                // mapData[x].push(layer.getPositionAt(cc.v2(x,y)));
                mapData[x].push(layer.getTileGIDAt(new cc.Vec2(x, y)));
            }
        }
        console.log(mapData);
        return mapData;
    }


    private _beginGame() {

        cc.log("开始游戏");
        cc.tween(this.tiledMap.node)
            .to(15,{x:-this.tiledMap.node.width*this.tiledMap.node.scaleX+this.node.parent.width / 2})
            .start();
    }
}

export class TiledGridInfo {
    b: number;
    gid: number;
    height: number;
    l: number;
    r: number;
    t: number;
    texId: number;
    tileset: cc.TMXTilesetInfo;
    width: number;
    x: number;
    y: number;
}