"use strict";
cc._RF.push(module, '2dcc3cQdulHkIujlFdPVEWA', 'EventMgr');
// Script/EventMgr.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
/***
 *
 *   █████▒█    ██  ▄████▄   ██ ▄█▀       ██████╗ ██╗   ██╗ ██████╗
 * ▓██   ▒ ██  ▓██▒▒██▀ ▀█   ██▄█▒        ██╔══██╗██║   ██║██╔════╝
 * ▒████ ░▓██  ▒██░▒▓█    ▄ ▓███▄░        ██████╔╝██║   ██║██║  ███╗
 * ░▓█▒  ░▓▓█  ░██░▒▓▓▄ ▄██▒▓██ █▄        ██╔══██╗██║   ██║██║   ██║
 * ░▒█░   ▒▒█████▓ ▒ ▓███▀ ░▒██▒ █▄       ██████╔╝╚██████╔╝╚██████╔╝
 *  ▒ ░   ░▒▓▒ ▒ ▒ ░ ░▒ ▒  ░▒ ▒▒ ▓▒       ╚═════╝  ╚═════╝  ╚═════╝
 *  ░     ░░▒░ ░ ░   ░  ▒   ░ ░▒ ▒░
 *  ░ ░    ░░░ ░ ░ ░        ░ ░░ ░
 *           ░     ░ ░      ░  ░
 *
 *
 *	本代码作者：山水有相逢
 *	《事件管理器》
 */
var EventMgr = /** @class */ (function (_super) {
    __extends(EventMgr, _super);
    function EventMgr() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.events_map = {};
        //#region 事件名
        /**数据更新事件 */
        _this.dataUpdateEvent = {};
        //#endregion
        //#region 系统事件
        _this.Game_Event = {
            /**开始游戏 */
            beginGame: "beginGame",
        };
        return _this;
        //#endregion
    }
    EventMgr_1 = EventMgr;
    EventMgr.prototype.onLoad = function () {
        if (EventMgr_1.Instance === null) {
            EventMgr_1.Instance = this;
            cc.log("STATE:[EventMgr.ts]      事件管理系统初始化完成！");
        }
        else {
            this.destroy();
            return;
        }
    };
    //#endregion
    //#region 事件函数
    /**
     * 添加一个事件的监听
     * @param event_name    事件名
     * @param caller        订阅对象 this
     * @param func          回调函数
     */
    EventMgr.prototype.add_event_listenner = function (event_name, caller, func) {
        if (!!!this.events_map[event_name]) {
            this.events_map[event_name] = [];
        }
        var event_queue = this.events_map[event_name];
        event_queue.push({
            caller: caller,
            func: func
        });
    };
    /**
     * 移除一个事件的监听
     * @param event_name    事件名
     * @param caller        订阅对象 this
     * @param func          回调函数
     */
    EventMgr.prototype.remove_event_listenner = function (event_name, caller, func) {
        if (!!!this.events_map[event_name]) {
            return;
        }
        var event_queue = this.events_map[event_name];
        for (var i = 0; i < event_queue.length; i++) {
            var obj = event_queue[i];
            if (obj.caller == caller && obj.func == func) {
                event_queue.splice(i, 1);
                break;
            }
        }
        if (event_queue.length <= 0) {
            this.events_map[event_name] = null;
        }
    };
    /**
     * 发送事件
     * @param event_name    事件名
     * @param udata         传输的数据对象
     */
    EventMgr.prototype.dispatch_event = function (event_name, udata) {
        if (!this.events_map[event_name]) {
            return;
        }
        var event_queue = this.events_map[event_name];
        for (var i = 0; i < event_queue.length; i++) {
            var obj = event_queue[i];
            obj.func.call(obj.caller, event_name, udata);
        }
    };
    var EventMgr_1;
    EventMgr.Instance = null;
    EventMgr = EventMgr_1 = __decorate([
        ccclass
    ], EventMgr);
    return EventMgr;
}(cc.Component));
exports.default = EventMgr;

cc._RF.pop();