package org.cocos2dx.javascript.gromore;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;

import com.bytedance.msdk.adapter.TToast;
import com.bytedance.msdk.adapter.util.Logger;
import com.bytedance.msdk.api.AdError;
import com.bytedance.msdk.api.GMAdEcpmInfo;
import com.bytedance.msdk.api.reward.RewardItem;
import com.bytedance.msdk.api.v2.GMAdConstant;
import com.bytedance.msdk.api.v2.GMMediationAdSdk;
import com.bytedance.msdk.api.v2.GMSettingConfigCallback;
import com.bytedance.msdk.api.v2.ad.reward.GMRewardAd;
import com.bytedance.msdk.api.v2.ad.reward.GMRewardedAdListener;
import com.bytedance.msdk.api.v2.ad.reward.GMRewardedAdLoadCallback;
import com.bytedance.msdk.api.v2.slot.GMAdOptionUtil;
import com.bytedance.msdk.api.v2.slot.GMAdSlotRewardVideo;

import org.cocos2dx.javascript.AppActivity;
import org.cocos2dx.lib.Cocos2dxJavascriptJavaBridge;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Gromore SDK 控制器
public class GMAdMgr {
    public static String TAG ="GMAdMgr";
    public static AppActivity app=null;
    public static GMRewardAd mttRewardAd=null;
    public static boolean loadSuccess=false;
    public static String mVerticalCodeId="947010577";
    public static String mHorizontalCodeId="947010577";
    private static boolean isVertical; //是否加载竖屏
    // 激励视频是否播放完毕 发放奖励
    public static boolean  isRewarded=false;

    public static void init(@NonNull AppActivity context){
        app=context;
    }

    // 初始化sdk
    public static String initSdk () {
        Log.e(TAG, "initSdk");
        GMAdManagerHolder.init(app);
        return  "" ;
    }
    // 加载激励视频
    public static String loadVideo () {
        Log.e(TAG, "loadVideo");
        laodAdWithCallback(mVerticalCodeId, GMAdConstant.VERTICAL);
        return  "" ;
    }
    // 播放激励视频
    public static String playVideo () {
        Log.e(TAG, "播放激励视频");
        isRewarded=false;
        mttRewardAd.setRewardAdListener(mTTRewardedAdListener);
        mttRewardAd.showRewardAd(app);
        Logger.e(TAG, "adNetworkPlatformId: " + mttRewardAd.getAdNetworkPlatformId() + "   adNetworkRitId：" + mttRewardAd.getAdNetworkRitId() + "   preEcpm: " + mttRewardAd.getPreEcpm());
        return  "" ;
    }
    // 获取权限
    public static String getPermission(){
        Log.e(TAG, "getPermission");
        GMMediationAdSdk.requestPermissionIfNecessary(app);
        return  "" ;
    }

    //////////////////////////////////////////////////////////////

    /**
     * config回调
     */
    private static GMSettingConfigCallback mSettingConfigCallback = new GMSettingConfigCallback() {
        @Override
        public void configLoad() {
            Log.e(TAG, "load ad 在config 回调中加载广告");
            if (isVertical) {
                loadAd(mVerticalCodeId, GMAdConstant.VERTICAL);
            } else {
                loadAd(mHorizontalCodeId, GMAdConstant.HORIZONTAL);
            }
        }
    };

    private static void laodAdWithCallback(final String adUnitId, final int orientation) {
        /**
         * 判断当前是否存在config 配置 ，如果存在直接加载广告 ，如果不存在则注册config加载回调
         */
        if (GMMediationAdSdk.configLoadSuccess()) {
            Log.e(TAG, "load ad 当前config配置存在，直接加载广告");
            loadAd(adUnitId, orientation);
        } else {
            Log.e(TAG, "load ad 当前config配置不存在，正在请求config配置....");
            GMMediationAdSdk.registerConfigCallback(mSettingConfigCallback); //不用使用内部类，否则在ondestory中无法移除该回调
        }
    }

    public static void loadAd(final String adUnitId, int orientation) {
        /**
         * 注：每次加载激励视频广告的时候需要新建一个TTRewardAd，否则可能会出现广告填充问题
         * （ 例如：mttRewardAd = new GMRewardAd(this, adUnitId);）
         */
        mttRewardAd = new GMRewardAd(app, adUnitId);

        Map<String, String> customData = new HashMap<>();
        customData.put(GMAdConstant.CUSTOM_DATA_KEY_PANGLE, "pangle media_extra");
        customData.put(GMAdConstant.CUSTOM_DATA_KEY_GDT, "gdt custom data");
        customData.put(GMAdConstant.CUSTOM_DATA_KEY_KS, "ks custom data");
        // 其他需要透传给adn的数据。

        GMAdSlotRewardVideo adSlotRewardVideo = new GMAdSlotRewardVideo.Builder()
                .setMuted(true)//对所有SDK的激励广告生效，除需要在平台配置的SDK，如穿山甲SDK
                .setVolume(0f)//配合Admob的声音大小设置[0-1]
                .setGMAdSlotGDTOption(GMAdOptionUtil.getGMAdSlotGDTOption().build())
                .setGMAdSlotBaiduOption(GMAdOptionUtil.getGMAdSlotBaiduOption().build())
                .setCustomData(customData)
                .setRewardName("金币") //奖励的名称
                .setRewardAmount(3)  //奖励的数量
                .setUserID("user123")//用户id,必传参数
                .setUseSurfaceView(true)
                .setOrientation(orientation)//必填参数，期望视频的播放方向：GMAdConstant.HORIZONTAL 或 GMAdConstant.VERTICAL
                .build();

        //请求广告
        mttRewardAd.loadAd(adSlotRewardVideo, new GMRewardedAdLoadCallback() {

            @Override
            public void onRewardVideoLoadFail(AdError adError) {
                loadSuccess = false;
                Log.e(TAG, "load RewardVideo ad error : " + adError.code + ", " + adError.message);
                // 获取本次waterfall加载中，加载失败的adn错误信息。
                if (mttRewardAd != null)
                    Log.d(TAG, "reward ad loadinfos: " + mttRewardAd.getAdLoadInfoList());
            }

            @Override
            public void onRewardVideoAdLoad() {
                loadSuccess = true;
                /**
                 * 获取已经加载的clientBidding ，多阶底价广告的相关信息
                 */
                List<GMAdEcpmInfo> gmAdEcpmInfos = mttRewardAd.getMultiBiddingEcpm();
                if (gmAdEcpmInfos != null) {
                    for (GMAdEcpmInfo info : gmAdEcpmInfos) {
                        Log.e(TAG, "***多阶+client相关信息*** AdNetworkPlatformId" + info.getAdNetworkPlatformId()
                                + "  AdNetworkRitId:" + info.getAdNetworkRitId()
                                + "  ReqBiddingType:" + info.getReqBiddingType()
                                + "  PreEcpm:" + info.getPreEcpm()
                                + "  LevelTag:" + info.getLevelTag()
                                + "  ErrorMsg:" + info.getErrorMsg());
                    }
                }

                /**
                 * 获取实时填充/缓存池中价格最优的代码位信息即相关价格信息，每次只有一个信息
                 */
                GMAdEcpmInfo gmAdEcpmInfo = mttRewardAd.getBestEcpm();
                if (gmAdEcpmInfo != null) {
                    Log.e(TAG, "***实时填充/缓存池中价格最优的代码位信息*** AdNetworkPlatformId" + gmAdEcpmInfo.getAdNetworkPlatformId()
                            + "  AdNetworkRitId:" + gmAdEcpmInfo.getAdNetworkRitId()
                            + "  ReqBiddingType:" + gmAdEcpmInfo.getReqBiddingType()
                            + "  PreEcpm:" + gmAdEcpmInfo.getPreEcpm()
                            + "  LevelTag:" + gmAdEcpmInfo.getLevelTag()
                            + "  ErrorMsg:" + gmAdEcpmInfo.getErrorMsg());
                }

                /**
                 * 获取获取当前缓存池的全部信息
                 */
                List<GMAdEcpmInfo> gmCacheInfos = mttRewardAd.getCacheList();
                if (gmCacheInfos != null) {
                    for (GMAdEcpmInfo info : gmCacheInfos) {
                        Log.e(TAG, "***缓存池的全部信息*** AdNetworkPlatformId" + info.getAdNetworkPlatformId()
                                + "  AdNetworkRitId:" + info.getAdNetworkRitId()
                                + "  ReqBiddingType:" + info.getReqBiddingType()
                                + "  PreEcpm:" + info.getPreEcpm()
                                + "  LevelTag:" + info.getLevelTag()
                                + "  ErrorMsg:" + info.getErrorMsg());
                    }
                }

                Log.e(TAG, "load RewardVideo ad success !" + mttRewardAd.isReady());
                // 获取本次waterfall加载中，加载失败的adn错误信息。
                if (mttRewardAd != null)
                    Log.d(TAG, "reward ad loadinfos: " + mttRewardAd.getAdLoadInfoList());
            }

            @Override
            public void onRewardVideoCached() {
                Log.d(TAG, "onRewardVideoCached....缓存成功" + mttRewardAd.isReady());
                loadSuccess = true;
                TToast.show(app, "激励视频素材缓存成功！");
            }
        });
    }


    /**
     * 激励视频交互回调
     */
    private static GMRewardedAdListener mTTRewardedAdListener = new GMRewardedAdListener() {

        /**
         * 广告的展示回调 每个广告仅回调一次
         */
        public void onRewardedAdShow() {
            TToast.show(app, "广告的展示回调！");
            Log.d(TAG, "广告的展示回调");

        }

        /**
         * show失败回调。如果show时发现无可用广告（比如广告过期或者isReady=false），会触发该回调。
         * 开发者应该结合自己的广告加载、展示流程，在该回调里进行重新加载。
         * @param adError showFail的具体原因
         */
        @Override
        public void onRewardedAdShowFail(AdError adError) {
            int errCode = 0;
            String errMsg = "";
            if (adError != null) {
                errCode = adError.thirdSdkErrorCode;
                errMsg = adError.thirdSdkErrorMessage;
            }
            TToast.show(app, "show失败回调！ errCode: " + errCode + ", errMsg: " + errMsg);
            Log.d(TAG, "show失败回调, errCode: " + errCode + ", errMsg: " + errMsg);

            // 开发者应该结合自己的广告加载、展示流程，在该回调里进行重新加载
            if (isVertical) {
                loadAd(mVerticalCodeId, GMAdConstant.VERTICAL);
            } else {
                loadAd(mHorizontalCodeId, GMAdConstant.HORIZONTAL);
            }
        }

        /**
         * 注意Admob的激励视频不会回调该方法
         */
        @Override
        public void onRewardClick() {
            Log.d(TAG, "注意Admob的激励视频不会回调该方法");
            TToast.show(app, "注意Admob的激励视频不会回调该方法！");

        }

        /**
         * 广告关闭的回调
         */
        public void onRewardedAdClosed() {
            Log.d(TAG, "广告关闭的回调");
            TToast.show(app, "激励广告关闭的回调！");

            app.runOnGLThread(new Runnable() {
                @Override
                public void run() {
                    //GL 线程调用js
                   if(isRewarded){
                       // 1 激励视频观看完成发放奖励
                       Cocos2dxJavascriptJavaBridge.evalString("eventCenter.emit(\"GM_VIDEO_AD_SUCCESS\",\"1\")");
                   }else {
                       // 0 激励视频 中途退出不发放奖励
                       Cocos2dxJavascriptJavaBridge.evalString("eventCenter.emit(\"GM_VIDEO_AD_FAIL\",\"0\")");
                   }

                }
            });

        }

        /**
         * 视频播放完毕的回调 Admob广告不存在该回调
         */
        public void onVideoComplete() {
            Log.d(TAG, "频播放完毕的回调");
            TToast.show(app, "激励 频播放完毕的回调！");
            isRewarded=true;
        }

        /**
         * 1、视频播放失败的回调
         */
        public void onVideoError() {
            Log.d(TAG, "视频播放失败的回调");
            TToast.show(app, "激励 视频播放失败的回调！");

        }

        /**
         * 激励视频播放完毕，验证是否有效发放奖励的回调
         */
        public void onRewardVerify(RewardItem rewardItem) {
            Map<String, Object> customData = rewardItem.getCustomData();
            if (customData != null) {
                String adnName = (String) customData.get(RewardItem.KEY_ADN_NAME);
                switch (adnName) {
                    case RewardItem.KEY_GDT:
                        Logger.d(TAG, "rewardItem gdt: " + customData.get(RewardItem.KEY_GDT_TRANS_ID));
                        break;
                }
            }
            Log.d(TAG, "激励视频播放完毕 验证是否有效发放奖励的回调");
            TToast.show(app, "激励视频播放完毕！验证是否有效发放奖励的回调");
            isRewarded=true;
        }

        /**
         * - Mintegral GDT Admob广告不存在该回调
         */
        @Override
        public void onSkippedVideo() {

        }

    };
}
