
const {ccclass, property} = cc._decorator;

@ccclass
export default class SceneMain extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    protected _mesh: cc.Mesh = null;
    protected _renderer: cc.MeshRenderer = null;

    start () {
        this._renderer = this.getComponentInChildren(cc.MeshRenderer);

        //@ts-ignore
		let gfx = cc.gfx;
		let vfmtCustom = new gfx.VertexFormat([
			{ name: 'a_position', type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
			{ name: 'a_uv0', type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
			{ name: gfx.ATTR_COLOR, type: gfx.ATTR_TYPE_UINT8, num: 4, normalize: true },       // 4个uint8
		]);
		vfmtCustom.name = 'vfmtCustom';

        this._mesh = new cc.Mesh;
		this._mesh.init(vfmtCustom, 100, true);
		this._renderer.mesh = this._mesh;

        let that = this;
        let row: number = 0;
        let vertices: cc.Vec2[] = [];
        let triangles: number[] = [];
        let mesh = this._mesh;
        this.schedule(() => {
            // quad数量随机
            let quad = 600 + Math.floor(Math.random() * 100 - 50);

            vertices.length = quad * 4;
            triangles.length = quad * 6;

            const rows = 80;
            let xDelta = 720 / 650;
            let yDelta = 1000 / rows;
            let y = row * yDelta;
            let x = 0; //-360;
            // let y = 0, x = 0;

            let startV = 0;
            let startI = 0;

            for (let i = 0; i < quad; ++i) {
                let pos = cc.v2(x, y);
                vertices[startV] = pos.add(cc.v2(-xDelta, -yDelta));
                vertices[startV+1] = pos.add(cc.v2(-xDelta, yDelta));
                vertices[startV+2] = pos.add(cc.v2(xDelta, -yDelta));
                vertices[startV+3] = pos.add(cc.v2(xDelta, yDelta));

                triangles[startI] = startV;
                triangles[startI+1] = startV+1;
                triangles[startI+2] = startV+2;
                triangles[startI+3] = startV+2;
                triangles[startI+4] = startV+1;
                triangles[startI+5] = startV+3;

                x += xDelta;
                startV += 4;
                startI += 6;
            }

            // 每次绘制重新init mesh不会有问题
            // mesh.clear();
            // mesh.init(vfmtCustom, vertices.length, true);
            // that._renderer.mesh = mesh;
            mesh.setVertices('a_position', vertices);
            mesh.setIndices(triangles, 0, true);
            row = (row + 1) % rows;
        }, 1);
    }


}
