import { _decorator, Component, Node, Color, Sprite, tween, Label, color } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Main')
export class Main extends Component {
    @property(Color)
    colors: Color[] = [];
    @property(Sprite)
    girds: Sprite[] = [];
    @property(Label)
    showLabel2: Label = null;

    rollValueObj2 = {
        value: 0
    };

    _curEndIndex: number = 0;
    _curStartIndex: number = 0;
    start() {

    }

    addRollValue2(val: number) {
        const newValue = this.rollValueObj2.value + val;
        this._curEndIndex = newValue;
        this._curStartIndex = newValue - val;
        tween(this.rollValueObj2)
            .to(5, { value: newValue }, {
                // 先慢后快最后慢
                easing: 'quartInOut',
                onUpdate: (target: { value: number }, ratio: number) => {
                    this.updateIndex(Math.floor(target.value))
                    this.showLabel2.string = Math.floor(target.value).toString();
                }
            })
            // .call(() => {
            //     this.finalPart(this.rollValueObj2.value);
            // })
            .start();
    }

    updateIndex(index) {
        for (let i = 0; i < this.girds.length; i++) {
            if (i == index % 14) {
                this.girds[i].color = this.colors[0];
            } else if (index - 1 >= this._curStartIndex && index <= this._curEndIndex - 5 && i == (index - 1) % 14) {
                this.girds[i].color = this.colors[1];
            } else if (index - 2 >= this._curStartIndex && index <= this._curEndIndex - 6 && i == (index - 2) % 14) {
                this.girds[i].color = this.colors[2];
            } else if (index - 3 >= this._curStartIndex && index <= this._curEndIndex - 7 && i == (index - 3) % 14) {
                this.girds[i].color = this.colors[3];
            } else if (index - 4 >= this._curStartIndex && index <= this._curEndIndex - 8 && i == (index - 4) % 14) {
                this.girds[i].color = this.colors[4];
            }
            else {
                this.girds[i].color = Color.WHITE;
            }
        }
    }

    finalPart(index) {
        let rIndex = 0;
        tween()
        this.schedule(() => {
            for (let i = 0; i < 4 - rIndex; i++) {
                this.girds[(index - i - 1) % 14].color = i + rIndex == 3 ? Color.WHITE : this.colors[i + 1]
            }
            rIndex++;
        }, 0.1, 4)
    }

    endAni() {

    }

    update(deltaTime: number) {

    }

    onStart() {
        this.addRollValue2(100);
    }
}

