import { _decorator,Node,instantiate, Component,game, Prefab, log} from 'cc';
import { ResManager } from './ResManager';

//加载的资源
export let loadingRes = [
    [
        //公用
        {path:"Prefabs/Common/MessagegBox",type:Prefab},
        {path:"Prefabs/Common/FloatTipsView",type:Prefab},
        {path:"Prefabs/Common/MessageBoxErrorInfo",type:Prefab},
        {path:"Prefabs/Common/LoadingView",type:Prefab},
    ],
    [
        //大厅
        {path:"Prefabs/HallView/HallView",type:Prefab},
    ]
]

enum LoadStep{
    None = -1,
    Common = 0,
    Hall   = 1,
    Game  = 2,
    Finish = LoadStep.Game + 1,
};

let LoadingData = [
    {state:LoadStep.Common,tips:"开始加载公共资源"},
    {state:LoadStep.Hall,tips:"加载大厅资源"},
    {state:LoadStep.Finish,tips:"加载结束"},
]


const { ccclass, property } = _decorator;

@ccclass('LoadingResourcesView')
export class LoadingResourcesView extends Component {
    private _count = 0;
    private _total = 0;

    private _state = LoadStep.None
    private _bCanLoad = true;
    private static _test = true;
    private _bCanUpdate = false;
    private currentMainView = null;

    onLoad() {
    }

    start(){
        this.startFly();
    }

    onEnable(){
        console.log("LoadingResourcesView::onEnable()");
    }

    onDisable() {
        console.log("LoadingResourcesView::onDisable()");
    } 

    onDestroy(){
        console.log("LoadingResourcesView::onDestroy()");
    }

    onRestartEvent(){
        this._bCanLoad = false;
    }

    startFly(){
        this._state = LoadStep.Common;
        this.startLoading();
    }

    async startLoading(){
        let self = this;
        if(loadingRes[this._state] && loadingRes[this._state].length > 0){
            console.log("=============%s==============",LoadingData[this._state].tips)
            this._total =  loadingRes[this._state].length;
            this._count = 0;
            this._bCanUpdate = true;

            if(LoadStep.Hall == this._state && LoadingResourcesView._test){
                LoadingResourcesView._test = false;
                setTimeout(() => {
                    new Promise<void>((resolve, reject)=>{
                        self.restartGame();
                        resolve();
                    })
                }, 650);
            }
            this.dowloadRes();
        }else
        {
            //所有资源加载结束了，链接网络
            console.log("加载结束");
            // let a = await ResManager.getInstance().loadResAsync('Prefabs/HallView/HallView',Prefab);
            // let node = instantiate(a);
            // node.parent = this.node;
       }
    }

    dowloadRes(){
        let self = this;
        if(!this._bCanLoad){
            console.log("停止加载资源！！！！！！！！！")
            return;
        }
        let data = loadingRes[this._state][this._count];
        if(!data || !data.path) return;
        console.log("开始加载资源：---------",data.path);
        ResManager.getInstance().loadResAsync2(data.path,data.type,()=>{
            self._count++;
            console.log("结束加载资源[%s]：%d/%d",data.path,self._count,self._total);
            self.dowloadRes();
        })
    }

    public restartGame() {
        new Promise<void>((resolve, reject) => {
            this._bCanLoad = false;
            console.log("================restartGame pureData Start================")
            ResManager.getInstance().destroyInstance();
            console.log("================restartGame pureData End================")
            resolve();
        }).then(() => {
            console.log("游戏状态-重启游戏")
            game.restart();
        })
    }

    update(dt: number) {
        if(!this._bCanUpdate){
            return;
        }
       if(loadingRes[this._state]){
            if(this._count < this._total){
                let curProgress = this._count/this._total;
            }else{
                this._bCanUpdate = false;
                //切换状态
                this.scheduleOnce(() => {
                    this._state++;
                    this.startLoading();
                }, 0.25);
            }
       }
       
    }
}
