import { _decorator, assetManager, SpriteFrame, sp, dragonBones, isValid, sys, Label, Node, Prefab, Asset, SpriteAtlas, js, path, ImageAsset, Sprite, Texture2D, UITransform, Material, AssetManager, SceneAsset, JsonAsset } from 'cc';


const { ccclass, property } = _decorator;

export type Constructor<T = unknown> = new (...args: any[]) => T;
export type AssetType<T = Asset> = Constructor<T>;

@ccclass('ResManager')
export class ResManager {

    public static _instance: ResManager;

    /**
    * 打开的预制体名字
    */
    private caches: any[] = [];


    public static getInstance(){
        if (!this._instance) {
            this._instance = new ResManager();
        }

        return this._instance;
    }

    public destroyInstance() {
        if (ResManager._instance == this) {
            console.log("ResManager destroyInstance");
            delete ResManager._instance;
            ResManager._instance = null;
        }
    }


    /** 
     * 加载资源
     * @param url 资源路径
     * @param type 资源类型
     * @param isCache 是否缓存，默认缓存
     * @example
     */
    public async loadResAsync(url: string, type: typeof Asset, isCache: boolean = true) {
        return new Promise<any>((resolve, reject) => {
            // 读取缓存资源
            let res:Asset = assetManager.resources.get(url, type);
            if (res ) {
                resolve(res);
            }else {
                assetManager.resources.load(url, type, (err, res) => {
                    if (err) {
                        console.log(err);
                        reject(err);
                    }else{
                        console.log("loadResAsync  x  ", url);
                        this.caches.unshift({ url: url, type: type ,res:res});
                        resolve(res);
                    }
                });
            }
        });
    }

    public loadResAsync2(url: string, type: typeof Asset, callback:Function) {
        // 读取缓存资源
        let res:Asset = assetManager.resources.get(url, type);
        if (res ) {
            callback &&callback(res);
        }else {
            assetManager.resources.load(url, type, (err, res) => {
                if (err) {
                    console.log(err);
                }else{
                    console.log("loadResAsync  x  ", url);
                    this.caches.unshift({ url: url, type: type ,res:res});
                    callback &&callback(res);
                }
            });
        }
    }
}