// Learn TypeScript:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class TbSpineTest extends cc.Component {

    @property(cc.Label)
    lblAniName: cc.Label = null;

    @property(sp.Skeleton)
    sp: sp.Skeleton = null;

    private _spineAniIdx: number = 0;
    private _spineAniName: string[] = ['Idle', 'Idle_B', 'Idle_B2', 'Idle_B3', 'Idle_B4', 'Idle_L', 'Idle_R', 'Walk', 'Walk_B', 'Walk_L', 'Walk_R'];

    onLoad() {
        this.changeSpAni()
    }

    private changeSpAni(): void {
        let name: string = this._spineAniName[this._spineAniIdx];
        this.lblAniName.string = name;
        this.sp.setAnimation(0, name, true);
    }

    public onBtnChangeSpAction(): void {
        this._spineAniIdx = (this._spineAniIdx + 1) % this._spineAniName.length;
        this.changeSpAni();
    }
}
