import { _decorator, CCInteger, Component, Node, Sprite, UIRenderer } from "cc";
const { ccclass, property } = _decorator;

@ccclass("zindex")
export class zindex extends Component {
    @property({ type: CCInteger, tooltip: "渲染层级" })
    ind: number = 0;
    protected onLoad(): void {
        let s = this;
        s.init();
    }
    /**保存渲染函数 */
    private fillBuffersFunc: (e: any) => void = null;
    private fillBuffersParams: any = null;
    /**初始化 */
    private init() {
        let s = this;
        let arr = s.node.components;
        let len = arr.length;
        for (let i = 0; i < len; i++) {
            let com = arr[i];
            if (com instanceof UIRenderer) {
                let func = com.fillBuffers;
                s.fillBuffersFunc = func.bind(com);
                com.fillBuffers = s.resFillBuffersFunc.bind(s);
                return;
            }
        }
    }

    /**恢复渲染函数 */
    private resFillBuffersFunc(params: any) {
        let s = this;
        s.fillBuffersParams = params;
    }
    /**执行渲染函数 */
    public fillBuffers() {
        let s = this;
        if (s.fillBuffersParams) {
            s.fillBuffersFunc(s.fillBuffersParams);
            s.fillBuffersParams = null;
        }
    }
}
