import { _decorator, Component, Node, UIRenderer } from "cc";
import { zindex } from "./zindex";
const { ccclass, property } = _decorator;

@ccclass("zindexManager")
export class zindexManager extends Component {
  private zindexCompArr: zindex[][] = [];
  public onLoad(): void {
    let s = this;
    s.initArr();

    let handler = function (com: any) {
      let func = com.postUpdateAssembler;
      com.postUpdateAssembler = (renderer: any) => {
        s.renderArr();
        func.call(com, renderer);
      };
    };

    let arr = s.node.components;
    let len = arr.length;
    for (let i = 0; i < len; i++) {
      let com = arr[i];
      if (com instanceof UIRenderer) {
        handler(com);
        return;
      }
    }

    let comp = s.node.addComponent(UIRenderer);
    handler(comp);
  }

  /**计算渲染数组 */
  public initArr(): void {
    let s = this;
    s.resetArr();
    let arr = s.node.getComponentsInChildren(zindex);
    let len = arr.length;
    for (let i = 0; i < len; i++) {
      let com = arr[i];
      let ind = com.ind;
      if (!s.zindexCompArr[ind]) {
        s.zindexCompArr[ind] = [];
      }
      s.zindexCompArr[ind].push(com);
    }

    console.log(s.zindexCompArr);
  }

  /**调用渲染 */
  public renderArr(): void {
    let s = this;
    let arr = s.zindexCompArr;
    let len = arr.length;
    for (let i = 0; i < len; i++) {
      let comArr = arr[i];
      if (comArr) {
        let len2 = comArr.length;
        for (let j = 0; j < len2; j++) {
          let com = comArr[j];
          com.fillBuffers();
        }
      }
    }
  }

  /**重置数组 */
  public resetArr(): void {
    let s = this;
    let arr = s.zindexCompArr;
    let len = arr.length;
    for (let i = 0; i < len; i++) {
      arr[i] && (arr[i].length = 0);
    }
  }
}
