import {
  _decorator,
  Component,
  instantiate,
  Label,
  Node,
  Prefab,
  Toggle,
} from "cc";
const { ccclass, property } = _decorator;

@ccclass("mainScene")
export class mainScene extends Component {
  @property(Node)
  content1: Node = null;
  @property(Node)
  content2: Node = null;

  @property(Prefab)
  item1: Prefab = null;
  @property(Prefab)
  item2: Prefab = null;

  protected onLoad(): void {
    let s = this;

    for (let j = 0; j < 30; j++) {
      let item = instantiate(s.item1);
      s.content1.addChild(item);
      item.getChildByName("ind").getComponent(Label).string = "合批" + j;

      item = instantiate(s.item2);
      s.content2.addChild(item);
      item.getChildByName("ind").getComponent(Label).string = "不合批" + j;
    }
  }

  private updataShow(obj: Toggle) {
    let s = this;
    s.content1.active = obj.isChecked;
    s.content2.active = !obj.isChecked;
  }
}
