import { _decorator, Component, Canvas, RenderTexture, view, native } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('NewComponent')
export class NewComponent extends Component {
    start() {
        this.test();
        this.scheduleOnce(() => {
            this.test();
        }, 1.0);
    }

    test() {
        let vSize = view.getVisibleSize();
        const renderTex = new RenderTexture();
        let camera = this.node.getComponent(Canvas).cameraComponent;
        renderTex.reset(Object.assign({}, vSize));
        camera.targetTexture = renderTex;
        this.scheduleOnce(() => {
            if (native.saveImageData) {
                native.saveImageData(
                    renderTex.readPixels(),
                    vSize.width,
                    vSize.height,
                    `${native.fileUtils.getWritablePath()}${new Date().getTime()}.png`);
            }
            camera.targetTexture = null;
            renderTex.decRef();
        }, 0);
    }
}

