import { _decorator, Camera, Component, log, native, Node, RenderTexture, Sprite, SpriteFrame } from 'cc';
import {uint8ArrayToBase64,base64ToUint8Array} from './DataTransfer';
import { NATIVE } from 'cc/env';

const { ccclass, property } = _decorator;

@ccclass('Buffer')
export class Buffer extends Component {

    @property(Sprite)
    sprite:Sprite = null;

    @property(Camera)
    camera:Camera = null;

    private renderTexture:RenderTexture|null=null;
    private texPixels:Uint8Array | null = null;

    start() {
        if (!this.camera) {
            return;
        }

        this.renderTexture = new RenderTexture();
        this.renderTexture.reset({
            width:256,
            height:256,
        });
        this.camera.targetTexture = this.renderTexture;
    }

    update(deltaTime: number) {
        if (!this.camera) {
            return;
        }
        // const width = this.renderTexture.width;
        // const height = this.renderTexture.height;
        // this.texPixels = new Uint8Array(width*height*4);
        // this.renderTexture.readPixels(0,0,width,height,this.texPixels);
        
        this.sprite.spriteFrame.texture = this.renderTexture; 
        // 将数据转化并传输到java层

        // 延迟一帧读取像素数据
        this.scheduleOnce(() => {
            const width = this.renderTexture.width;
            const height = this.renderTexture.height;
            this.texPixels = new Uint8Array(width * height * 4);
            this.renderTexture.readPixels(0, 0, width, height, this.texPixels);

            // 将数据转化并传输到 Java 层
            var data = uint8ArrayToBase64(this.texPixels);
            console.log("Native 外面", this.texPixels);
            console.log("Enter Native Layer before!!!");
            if (NATIVE) {
                native.bridge.sendToNative("sendBufferData", data);
                console.log("Enter Native Layer!!!");
                console.log("Native 里面", this.texPixels);
            }
            console.log("Enter Native Layer After!!!");
        }, 0); // 0表示下一帧
    }
}


