import { _decorator, Camera, Component, Director, director, Game, game, gfx, ImageAsset, Node, RenderTexture, Sprite, SpriteFrame, Texture2D } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('CaptureFrame')
export class CaptureFrame extends Component {

    private mSprite: Sprite | null = null;

    start() {
        this.mSprite = this.node.getComponent(Sprite);
    }


    update(deltaTime: number) {
        const currentTexture = this.mSprite.spriteFrame.texture;

        const renderTexture = new RenderTexture();
        renderTexture.reset({
            width: currentTexture.width,
            height: currentTexture.height
        });
        
        // const buffer = new Uint8Array(renderTexture.width*renderTexture.height*4);
        // renderTexture.readPixels(0,0,currentTexture.width,currentTexture.height,buffer);
        // console.log(buffer);

        const tempSpriteFrame = new SpriteFrame();
        tempSpriteFrame.texture = currentTexture;
        
        director.once(Director.EVENT_AFTER_DRAW,()=>{
            const width = currentTexture.width;
            const height = currentTexture.height;
            const buffer = new Uint8Array(width*height*4);
            renderTexture.readPixels(0,0,width,height,buffer);
            // console.log(buffer);
        })

    }
}


