import { _decorator, Component, director, Node } from 'cc';
const { ccclass, property } = _decorator;


@ccclass('GameMgr')
export class GameMgr extends Component {
    private static _instance: GameMgr = null;

    // 游戏状态管理
    private score: string = '';

    public static getInstance(): GameMgr {
        if (!GameMgr._instance) {
            throw new Error('GameMgr instance not found. Please ensure the GameMgr component is attached to a node in the scene.');
        }
        return GameMgr._instance;
    }

    onLoad() {
        console.log('GameMgr onLoad');


    }

    start() {
        // 防止重复实例
        if (GameMgr._instance && GameMgr._instance !== this) {
            console.warn('Duplicate GameMgr instance detected. Destroying this node.');
            this.node.destroy();
            return;
        }
        GameMgr._instance = this;
        // 设置为常驻节点
        director.addPersistRootNode(this.node);
        // 初始化游戏配置
        this.initializeGame();
    }

    private initializeGame() {
        // 初始化游戏设置
        console.log('Game initialized');
        // this.addScore(10); // 示例：添加分数
    }



    public getScore(): string {
        return this.score;
    }

    public addScore(score: string) {
        this.score = score;
        // 这里可以添加分数更新的回调
    }

}
