/*
 * @Author: GM
 * @Date: 2021-11-30 11:03:37
 * @LastEditTime: 2022-03-24 14:14:49
 * @LastEditors: Please set LastEditors
 * @Description: 
 * @FilePath: \elfMAtrix\assets\script\RootNode.ts
 */

// import baseData from "./basedata/baseData";
const { ccclass, property } = cc._decorator;
// https://buckettest-filestore123.oss-cn-beijing.aliyuncs.com/gen-spine/10.atlas
@ccclass
export default class test extends cc.Component {
    protected onLoad(): void {
        this.initspine();
    }

    protected start(): void {
    }
    async initspine() {
        // 初始化骨骼动画
        let httpCom = "https://buckettest-filestore123.oss-cn-beijing.aliyuncs.com"
        let spineroot = "/aaa-bbb/";
        let str = ["10", "100", "1000", "10", "100", "1000"];
        let moleSpineRes = []
        for (let index = 0; index < str.length; index++) {
            moleSpineRes.push(
                {
                    atlasSrc: httpCom + spineroot + str[index] + "/" + str[index] + ".atlas",
                    jsonSrc: httpCom + spineroot + str[index] + "/" + str[index] + ".json",
                    imageSrc: httpCom + spineroot + str[index] + "/" + str[index] + ".png"
                }
            )
        }
        let moleSpineAsset: string[][] = []
        for (let index = 0; index < str.length; index++) {
            moleSpineAsset.push(
                [
                    moleSpineRes[index].atlasSrc,
                    moleSpineRes[index].jsonSrc,
                    moleSpineRes[index].imageSrc,
                ]
            )
        }
        let moleSpineData: any[] = [[], [], [], [], [], []];
        try {
            for (let index = 0; index < moleSpineData.length; index++) {
                moleSpineData[index] = await Promise.all(
                    moleSpineAsset[index].map((v) => loadRemote(v))
                );
            }
        } catch (error) {
            throw new Error(`自定义动画加载失败：${error}`);
        }
        let moleSpineArray: sp.Skeleton[] = cc
            .find("Canvas/loadroot")
            .getComponentsInChildren(sp.Skeleton)
            .filter((v) => ["pet"].includes(v.node.name));
        moleSpineArray.forEach((v, index) => {
            let asset = new sp.SkeletonData();
            asset.atlasText = moleSpineData[index][0].text;
            asset.skeletonJson = moleSpineData[index][1].json;
            asset.textures = [moleSpineData[index][2]];
            asset.textureNames = [str[index] + ".png"];
            v.skeletonData = asset;
            v.invalidAnimationCache()
            v.setSkin("earth");
            v.setAnimation(0, "idle", true);
        });
    }
}
/**
 * 加载远程资源方法
 *
 * @export
 * @param {string} path
 * @return {*}  {Promise<any>}
 */
export function loadRemote(path: string): Promise<any> {
    return new Promise<any>((resolve, reject) => {
        cc.assetManager.loadRemote(path, (error, asset) => {
            cc.log("loadRemote", 11111);
            if (error) reject(error);
            resolve(asset);
        });
    });
}
export function loadLoacalRes(path: string): Promise<any> {
    return new Promise<any>((resolve, reject) => {
        cc.loader.loadRes(path, (error, asset) => {
            cc.log("loadRemote", 222222);
            if (error) reject(error);
            console.log(asset);
            resolve(asset);
        });
    });
}

