#!/bin/bash

function core:os() {
    echo $(uname)
}

############################
# 给文字加色

function core:null_tput() {
    return 0
}

if tty -s; then
    TPUT_COMMAND=tput
else
    TPUT_COMMAND=core:null_tput
fi

function core:endcolor() {
    echo $@$($TPUT_COMMAND sgr0)
}

function core:bold_text() {
    echo $($TPUT_COMMAND bold)$@
}

function core:bold_text_f() {
    echo $(core:endcolor $($TPUT_COMMAND bold)$@)
}

function core:red_text() {
    echo $($TPUT_COMMAND setaf 1)$@
}

function core:red_text_f() {
    echo $(core:endcolor $($TPUT_COMMAND setaf 1)$@)
}

function core:green_text() {
    echo $($TPUT_COMMAND setaf 2)$@
}

function core:green_text_f() {
    echo $(core:endcolor $($TPUT_COMMAND setaf 2)$@)
}

function core:yellow_text() {
    echo $($TPUT_COMMAND setaf 3)$@
}

function core:yellow_text_f() {
    echo $(core:endcolor $($TPUT_COMMAND setaf 3)$@)
}

function core:blue_text() {
    echo $($TPUT_COMMAND setaf 4)$@
}

function core:blue_text_f() {
    echo $(core:endcolor $($TPUT_COMMAND setaf 4)$@)
}

function core:magenta_text() {
    echo $($TPUT_COMMAND setaf 5)$@
}

function core:magenta_text_f() {
    echo $(core:endcolor $($TPUT_COMMAND setaf 5)$@)
}

function core:cyan_text() {
    echo $($TPUT_COMMAND setaf 6)$@
}

function core:cyan_text_f() {
    echo $(core:endcolor $($TPUT_COMMAND setaf 6)$@)
}

function core:white_text() {
    echo $($TPUT_COMMAND setaf 7)$@
}

function core:white_text_f() {
    echo $(core:endcolor $($TPUT_COMMAND setaf 7)$@)
}

function core:gray_text() {
    echo $($TPUT_COMMAND setaf 8)$@
}

function core:gray_text_f() {
    echo $(core:endcolor $($TPUT_COMMAND setaf 8)$@)
}


############################
# 打印信息

function core:debugf() {
    echo $(core:green_text_f $(core:bold_text "Debug:")) $(core:bold_text_f $@)
}

function core:infof() {
    echo $@
}

function core:alertf() {
    echo $(core:bold_text_f $@)
}

function core:warnf() {
    echo $(core:yellow_text_f $(core:bold_text "Warn:")) $(core:bold_text_f $@)
}

function core:errorf() {
    local _header
    echo >&2 $_header $(core:red_text_f  $(core:bold_text "Error:")) $(core:bold_text_f $@)
}

function core:fatalf() {
    local _header
    echo >&2 $_header $(core:red_text_f  $(core:bold_text "Error:")) $(core:bold_text_f $@)
    exit 1
}

function core:init() {
    local _os=$(core:os)
    echo run os is: $_os
}

core:init $@
