export * from './lib/Log';
export * from './lib/LogObject';

/*
export enum LogLevel {
    Error = 1,
    Warning = 2,
    Debug = 3
}

export class Log {
    static LEVEL: LogLevel = LogLevel.Debug;

    static setLevel(level: LogLevel) {
        Log.LEVEL = level;
    }

    private static _timeStamp(): string{
        let ret = '';
        let date = new Date();
        ret = `${date.getFullYear()}/${date.getMonth()}/${date.getDay()}`;
        ret += ` ${date.getHours()}:${date.getMinutes()}:${date.getSeconds()}`;
        ret += `.${date.getMilliseconds()}`
        return ret;
    }

    private static _print(level:string, tag: string, infos: any[]): void{
        if (level === '[DEBUG]') {
            console.log(Log._timeStamp(), level, tag, infos.join(" "));
        }
        if (level === '[WARN]') {
            console.warn(Log._timeStamp(), level, tag, infos.join(" "));
        }
        if (level === '[ERROR]') {
            console.error(Log._timeStamp(), level, tag, infos.join(" "));
        }
    }

    static D(tag: string, ...infos:any[]): void{
        if (Log.LEVEL >= LogLevel.Debug) {
            Log._print("[DEBUG]", `[${tag}]`, infos);
        }
    }

    static W(tag: string, ...infos:any[]): void{
        if (Log.LEVEL >= LogLevel.Warning) {
            Log._print("[WARN]", `[${tag}]`, infos);
        }
    }

    static E(tag: string, ...infos:any[]): void{
        if (Log.LEVEL >= LogLevel.Error) {
            Log._print("[ERROR]", `[${tag}]`, infos);
        }
    }
}

export class LogObject {
    protected getTag(): string {
        return this.constructor.name;
    }

    protected log(...params: Object[]): void{
        let tag = this.getTag();
        Log.D(tag, ...params);
    }

    protected warn(...params: Object[]): void{
        let tag = this.getTag();
        Log.W(tag, ...params);
    }

    protected error(...params: Object[]): void{
        let tag = this.getTag();
        Log.E(tag, ...params);
    }

    protected assert (expression: boolean, msg: string) : void {
        if (!expression) throw Error(msg);
    }
}
*/
