/**
 * 日志模块
 * @author luning
 */

/**
 * 日志等级
 */
export enum LogLevel {
    Error = 1,
    Warning = 2,
    Debug = 3
}

export class Log {
    /**
     * 日志等级
     */
    static LEVEL: LogLevel = LogLevel.Debug;

    /**
     * 设置日志等级
     * @param level 日志等级
     */
    static setLevel(level: LogLevel) {
        Log.LEVEL = level;
    }

    /**
     * 获取时间戳
     * @returns 时间戳字符串
     */
    private static _timeStamp(): string{
        let ret = '';
        let date = new Date();
        ret = `${date.getFullYear()}/${date.getMonth()}/${date.getDay()}`;
        ret += ` ${date.getHours()}:${date.getMinutes()}:${date.getSeconds()}`;
        ret += `.${date.getMilliseconds()}`
        return ret;
    }

    /**
     * 打印日志
     * @param level 日志等级
     * @param tag 日志标识
     * @pram infos 打印的信息
     */
    private static _print(level:string, tag: string, infos: any[]): void{
        if (level === '[DEBUG]') {
            console.log(Log._timeStamp(), level, tag, infos.join(" "));
        }
        if (level === '[WARN]') {
            console.warn(Log._timeStamp(), level, tag, infos.join(" "));
        }
        if (level === '[ERROR]') {
            console.error(Log._timeStamp(), level, tag, infos.join(" "));
        }
    }

    /**
     * 输出调试信息
     * @param tag 日志标识
     * @param infos 需要打印的信息
     */
    static D(tag: string, ...infos:any[]): void{
        if (Log.LEVEL >= LogLevel.Debug) {
            Log._print("[DEBUG]", `[${tag}]`, infos);
        }
    }

    /**
     * 输出警告信息
     * @param tag 日志标识
     * @param infos 需要打印的信息
     */
    static W(tag: string, ...infos:any[]): void{
        if (Log.LEVEL >= LogLevel.Warning) {
            Log._print("[WARN]", `[${tag}]`, infos);
        }
    }

    /**
     * 输出错误信息
     * @param tag 日志标识
     * @param infos 需要打印的信息
     */
    static E(tag: string, ...infos:any[]): void{
        if (Log.LEVEL >= LogLevel.Error) {
            Log._print("[ERROR]", `[${tag}]`, infos);
        }
    }
}

