import { Log } from './Log'
export class LogObject {
    /**
     * @returns 类名，现在主要是log的时候使用
     * @protected
     */
    protected getTag(): string {
        return this.constructor.name;
    }

    /**
     * @param params 打印的日志
     * @protected
     */
    protected log(...params: Object[]): void{
        let tag = this.getTag();
        Log.D(tag, ...params);
    }

    /**
     * 输出warn日志
     * @param params 打印的日志
     * @protected
     */
    protected warn(...params: Object[]): void{
        let tag = this.getTag();
        Log.W(tag, ...params);
    }

    /**
     * 输出error日志
     * @param params 打印的日志
     * @protected
     */
    protected error(...params: Object[]): void{
        let tag = this.getTag();
        Log.E(tag, ...params);
    }

    /**
     * 断言
     * @param expression 判断
     * @param msg 错误信息
     */
    protected assert (expression: boolean, msg: string) : void {
        if (!expression) throw Error(msg);
    }
}
