"use strict";
cc._RF.push(module, 'e1b90/rohdEk4SdmmEZANaD', 'Helloworld');
// Script/Helloworld.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Helloworld = /** @class */ (function (_super) {
    __extends(Helloworld, _super);
    function Helloworld() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.minSegment = 2;
        // ====== 缩放 ======
        _this.zoomStep = 1.1;
        _this.minScale = 0.2;
        _this.maxScale = 5;
        _this.zoomAtCursor = true;
        _this.camera = null; //烘焙相机
        _this._rt = null; // 历史纹理
        // private _cam: cc.Camera = null;         // 烘焙相机（把 Work 烘进 _rt）
        _this._drawing = false;
        _this._lastPt = null;
        _this.work = null; // 工作层（当前笔/橡皮绘制）
        _this.historySprite = null; // 显示历史纹理（可不拖，代码会自动创建）
        _this.bg = null;
        // clearFlags 常量（不清颜色 => 累计绘制）
        _this._CLR_COLOR = cc.Camera.ClearFlags.COLOR || 1;
        _this._CLR_DEPTH = cc.Camera.ClearFlags.DEPTH || 2;
        _this._CLR_STENCIL = cc.Camera.ClearFlags.STENCIL || 4;
        _this._path = [];
        // 获取像素数据
        _this._historyRT = null;
        return _this;
    }
    Object.defineProperty(Helloworld.prototype, "_NO_COLOR", {
        get: function () { return this._CLR_DEPTH | this._CLR_STENCIL; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Helloworld.prototype, "_WITH_COLOR", {
        get: function () { return this._CLR_COLOR | this._CLR_DEPTH | this._CLR_STENCIL; },
        enumerable: false,
        configurable: true
    });
    Helloworld.prototype.start = function () {
        this.initHistoryRT();
        this.addEvent();
    };
    Helloworld.prototype.addEvent = function () {
        // 事件（绘制 & 滚轮）
        this.node.on(cc.Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this.onTouchEnd, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.onTouchEnd, this);
        this.node.on(cc.Node.EventType.MOUSE_WHEEL, this.onMouseWheel, this);
    };
    // ===================== 滚轮缩放（作用在 bg） =====================
    Helloworld.prototype.onMouseWheel = function (e) {
        var scrollY = e.getScrollY();
        if (!scrollY)
            return;
        var factor = scrollY > 0 ? this.zoomStep : 1 / this.zoomStep;
        var old = this.bg.scale;
        var next = cc.misc.clampf(old * factor, this.minScale, this.maxScale);
        factor = next / old;
        if (factor === 1)
            return;
        if (!this.zoomAtCursor) {
            this.bg.scale = next;
            return;
        }
        var screen = e.getLocation();
        var localBefore = this.bg.convertToNodeSpaceAR(screen);
        this.bg.scale = next;
        var worldAfter = this.bg.convertToWorldSpaceAR(localBefore);
        var deltaWorld = screen.sub(worldAfter);
        var parent = this.bg.parent;
        var p0 = parent.convertToNodeSpaceAR(worldAfter);
        var p1 = parent.convertToNodeSpaceAR(worldAfter.add(deltaWorld));
        var deltaInParent = p1.sub(p0);
        this.bg.position = this.bg.position.add(deltaInParent);
    };
    Helloworld.prototype.onTouchStart = function (e) {
        var p = this.uiToLocal(e);
        // 检查触摸点是否在画布内，如果超出则不绘制
        this._drawing = true;
        this._lastPt = p.clone();
        this._path.length = 0;
        this._path.push(p);
        // 起笔补圆避免断头（可保留）
        this.work.clear(); // ✅ 预览层每次重绘前先清
        this.work.circle(p.x, p.y, this.work.lineWidth * 0.5);
        this.work.fill();
    };
    Helloworld.prototype.uiToLocal = function (event) {
        var p = event.getLocation();
        return this.bg.convertToNodeSpaceAR(p); // Work 与 HistorySprite 都在 bg 下，坐标统一
    };
    Helloworld.prototype.onTouchMove = function (e) {
        if (!this._drawing)
            return;
        var p = this.uiToLocal(e);
        if (this._lastPt && p.sub(this._lastPt).mag() < this.minSegment)
            return;
        this._path.push(p);
        this._lastPt = p;
        // ✅ 重绘一条路径（每帧 1 次 DC）
        this.work.clear();
        var first = this._path[0];
        this.work.moveTo(first.x, first.y);
        for (var i = 1; i < this._path.length; i++) {
            var pt = this._path[i];
            this.work.lineTo(pt.x, pt.y);
        }
        this.work.stroke(); // ✅ 只保留当前这一条预览线
    };
    Helloworld.prototype.onTouchEnd = function () {
        if (!this._drawing)
            return;
        this._drawing = false;
        // ✅ 一次性烘焙到 RT（history）
        this.commitWork();
        // ✅ 清掉预览
        this.work.clear();
        this._path.length = 0;
        this._lastPt = null;
    };
    /** 确保烘焙相机和 bg 对齐 */
    Helloworld.prototype.fitBakeCamToBG = function () {
        if (!this.camera)
            return;
        this.camera.alignWithScreen = false;
        this.camera.node.position = new cc.Vec3(this.bg.position.x, this.bg.position.y, 1);
        this.camera.orthoSize = (this.bg.height * 0.5) * this.bg.scaleY;
    };
    // ===================== 烘焙：把 Work 累计进历史纹理（仅渲染 work 组） =====================
    Helloworld.prototype.commitWork = function () {
        if (!this.camera || !this._rt || !this.work)
            return;
        this.fitBakeCamToBG();
        this.getPixelData();
        this.work.clear();
    };
    Helloworld.prototype.getPixelData = function () {
        var width = this._rt.width;
        var height = this._rt.height;
        var pixelData = new Uint8Array(width * height * 4); // RGBA 数据
        // 使用 renderTexture 获取像素数据
        this.camera.targetTexture = this._rt;
        this.camera.clearFlags = this._NO_COLOR;
        this.camera.backgroundColor = cc.color(0, 0, 0, 0);
        this.camera.alignWithScreen = false;
        this.camera.render();
        var result = this.filpYImage(this._rt.readPixels(), this._rt.width, this._rt.height);
        if (!this._historyRT) {
            this._historyRT = new cc.RenderTexture();
        }
        this._historyRT.initWithData(result, cc.Texture2D.PixelFormat.RGBA8888, width, height);
        var sf = new cc.SpriteFrame();
        sf.setTexture ? sf.setTexture(this._historyRT) : sf._setTexture(this._historyRT);
        this.historySprite.spriteFrame = sf;
        // pixelData 就是你绘制的内容的像素数据，可以进行后续处理
        // console.log(result);
    };
    // 像素y坐标翻转
    Helloworld.prototype.filpYImage = function (data, width, height) {
        // create the data array
        var picData = new Uint8Array(width * height * 4);
        var rowBytes = width * 4;
        for (var row = 0; row < height; row++) {
            var srow = height - 1 - row;
            var start = srow * width * 4;
            var reStart = row * width * 4;
            // save the piexls data
            for (var i = 0; i < rowBytes; i++) {
                picData[reStart + i] = data[start + i];
            }
        }
        return picData;
    };
    // ===================== 初始化：历史RT & Sprite =====================
    Helloworld.prototype.initHistoryRT = function () {
        var w = Math.max(1, Math.round(this.bg.width));
        var h = Math.max(1, Math.round(this.bg.height));
        this._rt = new cc.RenderTexture();
        // 2.4.x
        this._rt.initWithSize(w, h);
    };
    __decorate([
        property({ tooltip: "采样间距（像素）" })
    ], Helloworld.prototype, "minSegment", void 0);
    __decorate([
        property({ tooltip: "滚轮缩放倍率（>1放大）" })
    ], Helloworld.prototype, "zoomStep", void 0);
    __decorate([
        property
    ], Helloworld.prototype, "minScale", void 0);
    __decorate([
        property
    ], Helloworld.prototype, "maxScale", void 0);
    __decorate([
        property({ tooltip: "是否以鼠标为缩放中心" })
    ], Helloworld.prototype, "zoomAtCursor", void 0);
    __decorate([
        property(cc.Camera)
    ], Helloworld.prototype, "camera", void 0);
    __decorate([
        property(cc.Graphics)
    ], Helloworld.prototype, "work", void 0);
    __decorate([
        property(cc.Sprite)
    ], Helloworld.prototype, "historySprite", void 0);
    __decorate([
        property(cc.Node)
    ], Helloworld.prototype, "bg", void 0);
    Helloworld = __decorate([
        ccclass
    ], Helloworld);
    return Helloworld;
}(cc.Component));
exports.default = Helloworld;

cc._RF.pop();