
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Helloworld.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'e1b90/rohdEk4SdmmEZANaD', 'Helloworld');
// Script/Helloworld.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Helloworld = /** @class */ (function (_super) {
    __extends(Helloworld, _super);
    function Helloworld() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.minSegment = 2;
        // ====== 缩放 ======
        _this.zoomStep = 1.1;
        _this.minScale = 0.2;
        _this.maxScale = 5;
        _this.zoomAtCursor = true;
        _this.camera = null; //烘焙相机
        _this._rt = null; // 历史纹理
        // private _cam: cc.Camera = null;         // 烘焙相机（把 Work 烘进 _rt）
        _this._drawing = false;
        _this._lastPt = null;
        _this.work = null; // 工作层（当前笔/橡皮绘制）
        _this.historySprite = null; // 显示历史纹理（可不拖，代码会自动创建）
        _this.bg = null;
        // clearFlags 常量（不清颜色 => 累计绘制）
        _this._CLR_COLOR = cc.Camera.ClearFlags.COLOR || 1;
        _this._CLR_DEPTH = cc.Camera.ClearFlags.DEPTH || 2;
        _this._CLR_STENCIL = cc.Camera.ClearFlags.STENCIL || 4;
        _this._path = [];
        // 获取像素数据
        _this._historyRT = null;
        return _this;
    }
    Object.defineProperty(Helloworld.prototype, "_NO_COLOR", {
        get: function () { return this._CLR_DEPTH | this._CLR_STENCIL; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Helloworld.prototype, "_WITH_COLOR", {
        get: function () { return this._CLR_COLOR | this._CLR_DEPTH | this._CLR_STENCIL; },
        enumerable: false,
        configurable: true
    });
    Helloworld.prototype.start = function () {
        this.initHistoryRT();
        this.addEvent();
    };
    Helloworld.prototype.addEvent = function () {
        // 事件（绘制 & 滚轮）
        this.node.on(cc.Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this.onTouchEnd, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.onTouchEnd, this);
        this.node.on(cc.Node.EventType.MOUSE_WHEEL, this.onMouseWheel, this);
    };
    // ===================== 滚轮缩放（作用在 bg） =====================
    Helloworld.prototype.onMouseWheel = function (e) {
        var scrollY = e.getScrollY();
        if (!scrollY)
            return;
        var factor = scrollY > 0 ? this.zoomStep : 1 / this.zoomStep;
        var old = this.bg.scale;
        var next = cc.misc.clampf(old * factor, this.minScale, this.maxScale);
        factor = next / old;
        if (factor === 1)
            return;
        if (!this.zoomAtCursor) {
            this.bg.scale = next;
            return;
        }
        var screen = e.getLocation();
        var localBefore = this.bg.convertToNodeSpaceAR(screen);
        this.bg.scale = next;
        var worldAfter = this.bg.convertToWorldSpaceAR(localBefore);
        var deltaWorld = screen.sub(worldAfter);
        var parent = this.bg.parent;
        var p0 = parent.convertToNodeSpaceAR(worldAfter);
        var p1 = parent.convertToNodeSpaceAR(worldAfter.add(deltaWorld));
        var deltaInParent = p1.sub(p0);
        this.bg.position = this.bg.position.add(deltaInParent);
    };
    Helloworld.prototype.onTouchStart = function (e) {
        var p = this.uiToLocal(e);
        // 检查触摸点是否在画布内，如果超出则不绘制
        this._drawing = true;
        this._lastPt = p.clone();
        this._path.length = 0;
        this._path.push(p);
        // 起笔补圆避免断头（可保留）
        this.work.clear(); // ✅ 预览层每次重绘前先清
        this.work.circle(p.x, p.y, this.work.lineWidth * 0.5);
        this.work.fill();
    };
    Helloworld.prototype.uiToLocal = function (event) {
        var p = event.getLocation();
        return this.bg.convertToNodeSpaceAR(p); // Work 与 HistorySprite 都在 bg 下，坐标统一
    };
    Helloworld.prototype.onTouchMove = function (e) {
        if (!this._drawing)
            return;
        var p = this.uiToLocal(e);
        if (this._lastPt && p.sub(this._lastPt).mag() < this.minSegment)
            return;
        this._path.push(p);
        this._lastPt = p;
        // ✅ 重绘一条路径（每帧 1 次 DC）
        this.work.clear();
        var first = this._path[0];
        this.work.moveTo(first.x, first.y);
        for (var i = 1; i < this._path.length; i++) {
            var pt = this._path[i];
            this.work.lineTo(pt.x, pt.y);
        }
        this.work.stroke(); // ✅ 只保留当前这一条预览线
    };
    Helloworld.prototype.onTouchEnd = function () {
        if (!this._drawing)
            return;
        this._drawing = false;
        // ✅ 一次性烘焙到 RT（history）
        this.commitWork();
        // ✅ 清掉预览
        this.work.clear();
        this._path.length = 0;
        this._lastPt = null;
    };
    /** 确保烘焙相机和 bg 对齐 */
    Helloworld.prototype.fitBakeCamToBG = function () {
        if (!this.camera)
            return;
        this.camera.alignWithScreen = false;
        this.camera.node.position = new cc.Vec3(this.bg.position.x, this.bg.position.y, 1);
        this.camera.orthoSize = (this.bg.height * 0.5) * this.bg.scaleY;
    };
    // ===================== 烘焙：把 Work 累计进历史纹理（仅渲染 work 组） =====================
    Helloworld.prototype.commitWork = function () {
        if (!this.camera || !this._rt || !this.work)
            return;
        this.fitBakeCamToBG();
        this.getPixelData();
        this.work.clear();
    };
    Helloworld.prototype.getPixelData = function () {
        var width = this._rt.width;
        var height = this._rt.height;
        var pixelData = new Uint8Array(width * height * 4); // RGBA 数据
        // 使用 renderTexture 获取像素数据
        this.camera.targetTexture = this._rt;
        this.camera.clearFlags = this._NO_COLOR;
        this.camera.backgroundColor = cc.color(0, 0, 0, 0);
        this.camera.alignWithScreen = false;
        this.camera.render();
        var result = this.filpYImage(this._rt.readPixels(), this._rt.width, this._rt.height);
        if (!this._historyRT) {
            this._historyRT = new cc.RenderTexture();
        }
        this._historyRT.initWithData(result, cc.Texture2D.PixelFormat.RGBA8888, width, height);
        var sf = new cc.SpriteFrame();
        sf.setTexture ? sf.setTexture(this._historyRT) : sf._setTexture(this._historyRT);
        this.historySprite.spriteFrame = sf;
        // pixelData 就是你绘制的内容的像素数据，可以进行后续处理
        // console.log(result);
    };
    // 像素y坐标翻转
    Helloworld.prototype.filpYImage = function (data, width, height) {
        // create the data array
        var picData = new Uint8Array(width * height * 4);
        var rowBytes = width * 4;
        for (var row = 0; row < height; row++) {
            var srow = height - 1 - row;
            var start = srow * width * 4;
            var reStart = row * width * 4;
            // save the piexls data
            for (var i = 0; i < rowBytes; i++) {
                picData[reStart + i] = data[start + i];
            }
        }
        return picData;
    };
    // ===================== 初始化：历史RT & Sprite =====================
    Helloworld.prototype.initHistoryRT = function () {
        var w = Math.max(1, Math.round(this.bg.width));
        var h = Math.max(1, Math.round(this.bg.height));
        this._rt = new cc.RenderTexture();
        // 2.4.x
        this._rt.initWithSize(w, h);
    };
    __decorate([
        property({ tooltip: "采样间距（像素）" })
    ], Helloworld.prototype, "minSegment", void 0);
    __decorate([
        property({ tooltip: "滚轮缩放倍率（>1放大）" })
    ], Helloworld.prototype, "zoomStep", void 0);
    __decorate([
        property
    ], Helloworld.prototype, "minScale", void 0);
    __decorate([
        property
    ], Helloworld.prototype, "maxScale", void 0);
    __decorate([
        property({ tooltip: "是否以鼠标为缩放中心" })
    ], Helloworld.prototype, "zoomAtCursor", void 0);
    __decorate([
        property(cc.Camera)
    ], Helloworld.prototype, "camera", void 0);
    __decorate([
        property(cc.Graphics)
    ], Helloworld.prototype, "work", void 0);
    __decorate([
        property(cc.Sprite)
    ], Helloworld.prototype, "historySprite", void 0);
    __decorate([
        property(cc.Node)
    ], Helloworld.prototype, "bg", void 0);
    Helloworld = __decorate([
        ccclass
    ], Helloworld);
    return Helloworld;
}(cc.Component));
exports.default = Helloworld;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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