import { _decorator, Collider2D, Component, Contact2DType, IPhysics2DContact, Node, tween } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Demo')
export class Demo extends Component {

    private s : Node = null;

    private d : Node = null;

    protected onLoad(): void {
        this.s = this.node.getChildByName("S");
        this.d = this.node.getChildByName("D");
        tween(this.s).to(3,{position : this.d.position}).start();
    }

    start() {
        let collider = this.d.getComponent(Collider2D);
        if(collider){
            collider.on(Contact2DType.BEGIN_CONTACT,this.contactBack,this);
        }
    }

    contactBack(self:Collider2D,other:Collider2D,contact:IPhysics2DContact){
        console.log("撞")
    }

}

