import { GameEventEnum } from "../Project/Data/EventEnum";
import { GameEvent } from "../Project/Main/EventDispatcher";
import { FMgr } from "../_FutureCore/Manager/FMgr";

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {
    
    @property(cc.Prefab)
    public money: cc.Prefab = null

    @property(cc.Camera)
    public camera: cc.Camera = null

    onLoad () {
        GameEvent.on(GameEventEnum.SHOW_FALL_MONEY, this.onShowFallMoney, this)    
    }

    start () {
        
    }

    onShowFallMoney(pos: cc.Vec3) {
        let node = cc.instantiate(this.money)
        node.parent = this.node

        // let lPos = node.parent.convertToNodeSpaceAR(pos)

        let screen = this.camera.getWorldToScreenPoint(pos)
        console.log(screen.x, screen.y, screen.z)

        node.x = screen.x
        
        cc.tween(node).by(1, {y: 300}).delay(1).call(()=>{
            node.destroy()
        }).start()
        // cc.tween(node).delay(2).call(()=>{
        //     node.destroy()
        // }).start()
    }
    // update (dt) {}
}
