// 得到金额，若超过万，则每3位数增加逗号，并且取整
export function GetMoneyNum(money: number, isShowK: boolean = false): string {
    if (money / 10000 < 1) {
        return money.toFixed(2)
    }

    let str = ''
    let temp = Math.floor(money)
    let count = 0

    while (true) {
        let num = temp % 10
        count++
        str = num + str
        temp = Math.floor(temp / 10)
        if (temp <= 0) {
            break
        }

        if (count >= 3) {
            count = 0
            str = ',' + str
        }
    }

    return str
}