const {ccclass, property} = cc._decorator;

export enum SkinCardType {
    NONE = 0,
    SIX_CARD = 1,
    ROBOLOX = 2,
    FREEFIRE = 3,
    BRAWLSTARS = 4,
    MOBILELEGEND = 5,
}

@ccclass
export default class SkinImgSwitch extends cc.Component {

    @property({type: cc.Enum(SkinCardType)}) public skinCardType: SkinCardType = SkinCardType.NONE

    @property(cc.SpriteFrame) public roboloxImg: cc.SpriteFrame = null
    @property(cc.SpriteFrame) public freefireImg: cc.SpriteFrame = null
    @property(cc.SpriteFrame) public brawlstarsImg: cc.SpriteFrame = null
    @property(cc.SpriteFrame) public mobileLegendImg: cc.SpriteFrame = null

    @property(cc.Node)
    public label: cc.Node = null

    onLoad () {
        
    }

    start () {
        this.updateImg()
    }

    updateImg() {
        let sp = this.node.getComponent(cc.Sprite)
        if (!sp) {
            return
        }

        if (this.skinCardType == SkinCardType.ROBOLOX) {
            sp.spriteFrame = this.roboloxImg
            this.label.active = true
            return
        }

        if (this.skinCardType == SkinCardType.FREEFIRE) {
            sp.spriteFrame = this.freefireImg
            this.label.active = true
            return
        }

        if (this.skinCardType == SkinCardType.BRAWLSTARS) {
            sp.spriteFrame = this.brawlstarsImg
            this.label.active = true
            return
        }

        if (this.skinCardType == SkinCardType.MOBILELEGEND) {
            sp.spriteFrame = this.mobileLegendImg
            this.label.active = true
            return
        }

        this.label.active = false
    }
    // update (dt) {}
}
