import PGlobalUI from "../Project/Main/PGlobalUI";

const {ccclass, property} = cc._decorator;

@ccclass
export default class SkinManager extends cc.Component {
    public static ME: SkinManager = null

    @property
    public isSkinAdsPlayable: boolean = false

    onLoad () {
        SkinManager.ME = this    
    }

    start () {
        this.checkAdsPlayableType()
    }

    checkAdsPlayableType() {
        if (!this.isSkinAdsPlayable) {
            return
        }

        this.hidePaypalUI()
    }

    hidePaypalUI() {
        let paypal = PGlobalUI.Me.payPalUI
        if (!paypal) {
            return
        }

        let baseNode = paypal.baseNode
        if (baseNode) {
            baseNode.active = false
        }

        let logo = paypal.logo
        if (logo) {
            logo.active = true
        }
    }

    // update (dt) {}
}
