const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {
    @property(cc.Sprite)
    public sprite: cc.Sprite = null

    public camera: cc.Camera = null
    public texture: cc.RenderTexture = null
    public spriteFrame: cc.SpriteFrame = null
    
    onLoad () {
        this.camera = this.node.getComponent(cc.Camera)
	}

    start () {
        this.spriteFrame = new cc.SpriteFrame()
        this.sprite.spriteFrame = this.spriteFrame

        this.texture = new cc.RenderTexture()
        let size = cc.size(720, 1280)
        this.texture.initWithSize(size.width, size.height, cc.RenderTexture.DepthStencilFormat.RB_FMT_S8)

        this.camera.targetTexture = this.texture
        this.camera.enabled = false
        this.sprite.node.scaleY = -1
    }

    renderCamera() {
        this.camera.render(this.node.parent.parent)
        this.sprite.spriteFrame.setTexture(this.texture)
        
    }

    update (dt) {
        this.renderCamera()
    }
}
