import { GameEventEnum } from "../Data/EventEnum";
import { GameEvent } from "../Main/EventDispatcher";

const {ccclass, property} = cc._decorator;

@ccclass
export default class BoxMove extends cc.Component {
    public rb2d: cc.RigidBody3D = null
    public isCanMove: boolean = true
    public startPos: cc.Vec3 = null
    public startMove: boolean = false

    // -- time --
    public currentTime: number = 0
    public totalTime: number = 1

    onLoad () {
        this.rb2d = this.node.getComponent(cc.RigidBody3D)
        this.startPos = this.node.position

        GameEvent.on(GameEventEnum.RESET_ALL, this.onResetAll, this)
	}

    start () {
        this.scheduleOnce(()=>{
            this.move()
        }, 1)
    }

    onResetAll() {
        this.node.position = this.startPos
        this.rb2d.setLinearVelocity(cc.v3(0, 0, 0))
        this.currentTime = 0
        this.startMove = false
        this.isCanMove = true
        this.scheduleOnce(()=>{
            this.move()
        }, 1)
    }

    move() {
        if (!this.isCanMove) {
            return
        }

        this.isCanMove = false
        let count = 70
        let index = 0
        let val = 200 
        this.rb2d.setLinearVelocity(cc.v3(0, 0, val))
        this.startMove = true

        return
        this.schedule(()=>{
            index++
            if (index >= count / 2) {
                val = -Math.abs(val)
            }
            if (index == count) {
                val = 0
                this.isCanMove = true
            }

            this.rb2d.setLinearVelocity(cc.v3(0, 0, val))
        }, 0, count - 1)
    }

    update (dt) {
        if (!this.startMove) {
            return
        }

        this.currentTime += dt
        if (this.currentTime >= this.totalTime) {
            this.currentTime = 0
            GameEvent.emit(GameEventEnum.RESET_ALL)
        }
    }
}
