import { GameEventEnum } from "../Data/EventEnum";
import { GameEvent } from "../Main/EventDispatcher";

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {
    @property(cc.Prefab)
    public chip: cc.Prefab = null

    public posList: cc.Vec3[] = []

    onLoad () {
        GameEvent.on(GameEventEnum.RESET_ALL, this.onResetAll, this)
	}

    onResetAll() {
        this.node.destroyAllChildren()
        this.createChip()
    }

    start () {
        // this.schedule(()=>{
            this.createChip(true)
            // cc.tween(item).delay(3).call(()=>{
            //     item.destroy()
            // }).start()
        // }
        // }, 1, cc.macro.REPEAT_FOREVER)
    }

    createChip(start: boolean = false) {
        let count = 60
        for (let i = 0; i < count; i++) {
            let item = cc.instantiate(this.chip)
            item.parent = this.node
            
            if (start) {
                item.x = Math.random() * 8 - 4
                item.y += Math.random() * 5
                item.z = Math.random() * 10 - 2
                this.posList.push(item.position)
            } else {
                item.position = this.posList[i]
            }
        }
    }
    // update (dt) {}
}
