import { PaymentName, PaymentOutLine, PaymentType } from "../LanguageData";
const {ccclass, property} = cc._decorator;

@ccclass
export default class BaseCountry extends cc.Component {
    @property({
        type: cc.Enum(PaymentType),
    })
    public PaymentType: PaymentType = PaymentType.Paypal  // 支付方式

    public CountryName = null  // 国家名字(用于打印)
    public GameName = null  // 游戏名字
    public SecondName = null  // 第二名字
    public Icon = null  // Icon
    public InstallBtn = null  // 安装按钮
    public AndroidUrl = null  // 安卓链接
    public IosUrl = null  // Ios链接
    public MoneyConfig = null  // 金额配置
    public Title = null  // 游戏标题
    public GetCard = null  // 得卡界面
    public GetCardIcon = null  // 得卡小标记
    public FinishCard = null  // 结束界面
    public FinishBtn = null  // 结束按钮
    public finishOKFont = null  // 结束按钮文字
    public reverseMoneyTag = null  // 是否倒转金额标记
    
    public getTitle() {
        return 'title_wide/' + PaymentName[PaymentType[this.PaymentType]]
    }

    public getGetCard(): {bg: string, node?: string} {
        return {bg: 'common/card_bg', node: 'title_wide/' + PaymentName[PaymentType[this.PaymentType]]}
    }

    public getGetCardIcon() {
        return 'getcard_icon/' + PaymentName[PaymentType[this.PaymentType]]
    }

    public getFinishCard(): {bg: string, node?: string, labelOutLineColor?: cc.Vec3, fontOffset?: cc.Vec2, fontColor?: cc.Vec3, fontSize?: number} {
        let finishBg = this.getFinishBg()
        let finishTitle = this.getFinishTitle()
        let outLineColor = PaymentOutLine[PaymentType[this.PaymentType]] || cc.v3(35, 116, 198)
        
        return {bg: finishBg, node: finishTitle, labelOutLineColor: outLineColor, fontOffset: cc.v2(0, 40), fontColor: cc.v3(255, 255, 255), fontSize: 80}
    }

    public getFinishBtn(): {bg?: string, scale?: number, font?: string} {
        return {bg: 'common/blue_btn', scale: 1.2, font: 'Cash Out'}
    }

    public getFinishBg(): string {
        return 'finish/pic_big_' + PaymentName[PaymentType[this.PaymentType]] + '_di'
    }

    public getFinishTitle(): string {
        return 'finish/pic_big_' + PaymentName[PaymentType[this.PaymentType]]
    }
}
