// 国家
export enum Country {
    USA = 1,
    Thailand = 2,
    Indonesian = 3,
    Brazil = 4,
    Spain = 5,
    Vietnam = 6,
    Russia = 7,
    Malaysia = 8,
    Philippines = 9,
    Japan = 10,
    SaudiArabia = 11,
    UAE = 12,
    korea = 13,
    Germany = 14,
    Canada = 15,
    England = 16,
    France = 17,
    Turkey = 18,
    SouthAfrica = 19,
    Italy = 20,
}

// 支付方式
export enum PaymentType {
    Paypal = 1,
    Promptpay = 2,
    Dana = 3,
    Hipay = 4,
    Zalopay = 5,
    Qiwi = 6,
    Gcash = 7,
    Truemoney = 8,
    Picpay = 9,
    Pagseguro = 10,
    Grab = 11,
    Linepay = 12,
    Momo = 13,
    OVO = 14,
    Visa = 15,
    Boost = 16,
    Paypay = 17,
    Stcpay = 18,
    Kakaopay = 19,
    Amazon = 20,
}

// 支付方式文件对应名字
export enum PaymentName {
    Paypal = 'paypal',
    Promptpay = 'promptpay',
    Dana = 'dana',
    Hipay = 'hipay',
    Zalopay = 'zalopay',
    Qiwi = 'qiwi',
    Gcash = 'gcash',
    Truemoney = 'truemoney',
    Picpay = 'picpay',
    Pagseguro = 'pagseguro',
    Grab = 'grab',
    Linepay = 'linepay',
    Momo = 'momo',
    OVO = 'ovo',
    Visa = 'visa',
    Boost = 'boost',
    Paypay = 'paypay',
    Stcpay = 'stcpay',
    Kakaopay = 'kakaopay',
    Amazon = 'amazon',
}

// 普通颜色
let PaypalUIColor = {
    Paypal: cc.v3(0, 143, 255),
    Promptpay: cc.v3(0, 113, 241),
    Dana: cc.v3(84, 163, 228),
    Hipay: cc.v3(0, 143, 255),
    Zalopay: cc.v3(0, 188, 153),
    Qiwi: cc.v3(241, 154, 20),
    Gcash: cc.v3(0, 96, 230),
    Truemoney: cc.v3(255, 164, 46),
    Picpay: cc.v3(27, 195, 94),
    Pagseguro: cc.v3(0, 188, 153),
    Grab: cc.v3(23, 153, 65),
    Linepay: cc.v3(23, 153, 65),
    Momo: cc.v3(195, 29, 132),
    OVO: cc.v3(74, 50, 143),
    Visa: cc.v3(21, 90, 175),
    Boost: cc.v3(242, 46, 22),
    Paypay: cc.v3(242, 46, 22),
    Stcpay: cc.v3(127, 59, 228),
    Kakaopay: cc.v3(235, 242, 38), 
    Amazon: cc.v3(0, 0, 0),
}
export {PaypalUIColor}

// 字体描边颜色
let PaymentOutLine = {
    Paypal: cc.v3(35, 116, 198),
    Promptpay: cc.v3(35, 116, 198),
    Dana: cc.v3(35, 116, 198),
    Hipay: cc.v3(35, 116, 198),
    Zalopay: cc.v3(0, 152, 124),
    Qiwi: cc.v3(214, 121, 1),
    Gcash: cc.v3(8, 85, 199),
    Truemoney: cc.v3(214, 121, 1),
    Picpay: cc.v3(10, 119, 45),
    Pagseguro: cc.v3(0, 152, 124),
    Grab: cc.v3(10, 119, 45),
    Linepay: cc.v3(10, 119, 45),
    Momo: cc.v3(139,0,139),
    OVO: cc.v3(51, 27, 121),
    Visa: cc.v3(51, 27, 121),
    Boost: cc.v3(198, 58, 41),
    Paypay: cc.v3(198, 58, 41),
    Stcpay: cc.v3(115, 50, 192),
    Kakaopay: cc.v3(112, 100, 26),
    Amazon: cc.v3(40, 40, 40),
}
export {PaymentOutLine}

// 按钮颜色
let BtnColor = {
    Paypal: cc.v3(0, 143, 255),
    Promptpay: cc.v3(0, 113, 241),
    Dana: cc.v3(47, 152, 237),
    Hipay: cc.v3(0, 143, 255),
    Zalopay: cc.v3(0, 188, 153),
    Qiwi: cc.v3(241, 154, 20),
    Gcash: cc.v3(0, 96, 230),
    Truemoney: cc.v3(239, 139, 20),
    Picpay: cc.v3(27, 195, 94),
    Pagseguro: cc.v3(0, 188, 153),
    Grab: cc.v3(23, 153, 65),
    Linepay: cc.v3(23, 153, 65),
    Momo: cc.v3(195, 29, 132),
    OVO: cc.v3(74, 50, 143),
    Visa: cc.v3(21, 90, 175),
    Boost: cc.v3(242, 46, 22),
    Paypay: cc.v3(242, 46, 22),
    Stcpay: cc.v3(127, 59, 228),
    Kakaopay: cc.v3(235, 242, 38), 
    Amazon: cc.v3(0, 0, 0),
}
export {BtnColor}