import { GameEventEnum } from "../Data/EventEnum";
import { GameEvent } from "./EventDispatcher";

const {ccclass, property} = cc._decorator;

@ccclass
export default class GameManager extends cc.Component {

    public static ME: GameManager = null

    @property
    public isShortGame: boolean = false
    
    public isGameEnd: boolean = false  // 游戏结束，动画前判断
    public isGameEndAfterAni: boolean = false  // 游戏结束，动画后判断

    onLoad () {
        GameManager.ME = this
    }

    start () {
        GameEvent.emit(GameEventEnum.SET_SHORT_GAME, this.isShortGame)
    }

    // update (dt) {}
}
