import { GetMoneyNum } from "../../Modules/GlobalFunction";
import { FMgr } from "../../_FutureCore/Manager/FMgr";
import LanguageManager from "../Language/LanguageManager";
import PGlobalUI from "../Main/PGlobalUI";

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    private currentMoney: number = 0
	public startMoney: number = 0
    private totalMoney: number = 0
    public symbol: string = '$'

    setMoney(money?: number) {
		// this.startMoney = this.totalMoney
        this.totalMoney = money
        this.symbol = PGlobalUI.Me.payPalUI.symbol

		let count = 80
		let index = 0
		this.schedule(()=>{
            index++
			let n = this.getCurrentMoney(index, count)
			this.currentMoney = n
			this.currentMoney = Math.min(this.currentMoney, this.totalMoney)

            this.node.getComponent(cc.Label).string = '+' + this.symbol + GetMoneyNum(this.currentMoney)

            if (index % 5 == 0) {
                FMgr.Audio.PlayEffect('reward_gold_fly_tick', 2)
                FMgr.Audio.PlayEffect('collecGoldSound', 2)
            }

			if (index == count - 10) {
				FMgr.Audio.PlayEffect('win', 1.4)
				FMgr.Audio.PlayEffect('moreWow', 1.4)
			}
		}, 0, count - 1)
		
    }

	getCurrentMoney(x: number, total: number): number {
		let t = this.totalMoney - this.startMoney
		let x1 = x / total

		// return x == total ? this.totalMoney : (1 - Math.pow(2, -10 * x1)) * t
		return x == total ? this.totalMoney : (1 - (1 - x1) * (1 - x1)) * t
	}

    // update (dt) {
    //     if (this.currentMoney <= this.totalMoney) {
    //         let addScore = this.totalMoney - this.currentMoney;
	// 		if (addScore > 1000000)
	// 			this.currentMoney += 300000;
	// 		if (addScore > 100000)
	// 			this.currentMoney += 30000;
	// 		if (addScore > 10000)
	// 			this.currentMoney += 3000;
	// 		if (addScore > 10000)
	// 			this.currentMoney += 3000;
	// 		if (addScore > 1000)
	// 			this.currentMoney += 300;
	// 		else if (addScore > 100)
	// 			this.currentMoney += 30;
	// 		else if (addScore > 10)
	// 			this.currentMoney += 3;
	// 		else if (addScore > 3)
	// 			this.currentMoney += 0.3;
	// 		else
	// 			this.currentMoney += 0.1;

	// 		this.currentMoney = Math.min(this.currentMoney, this.totalMoney);//保证最大只能是score
    //         let money = ''
    //         if (this.currentMoney / 10000 > 1) {
    //             // money = (this.currentMoney / 1000).toFixed(0) + 'K'
	// 			money = GetMoneyNum(this.currentMoney)
    //         } else {
    //             money = this.currentMoney.toFixed(2)
    //         }

	// 		if (LanguageManager.ME.currentCountry.reverseMoneyTag) {
	// 			this.node.getComponent(cc.Label).string = money + this.symbol
	// 		} else {
	// 			this.node.getComponent(cc.Label).string = this.symbol + money
	// 		}
	// 	}
    // }
}
