import SkinManager from "../../Modules/SkinManager";
import FChannelControl from "../../_FutureCore/ChannelControl/FChannelControl";
import { FMgr } from "../../_FutureCore/Manager/FMgr";
import { BtnColor, PaymentOutLine } from "../Language/LanguageData";
import LanguageManager from "../Language/LanguageManager";
import GameManager from "../Main/GameManager";
import PGlobalUI from "../Main/PGlobalUI";

const { ccclass, property } = cc._decorator;

@ccclass
export default class FinishUI extends cc.Component {

    @property
    public isMoveImage: boolean = false

    @property(cc.Label)
    cashLabel: cc.Label = null

    @property(cc.Node)
    hand: cc.Node = null

    @property(cc.Node)
    btn: cc.Node = null

    @property(cc.Node)
    public glass: cc.Node = null

    @property(cc.Node)
    public finishInstall: cc.Node = null

    @property(cc.Node)
    public imageEndNode: cc.Node = null

    @property(cc.Node)
    public paymentNode: cc.Node = null
    
    @property(cc.Node)
    public skinNode: cc.Node = null

    @property([cc.Node])
    public particleNodeList: cc.Node[] = []

    onLoad() {
        if (this.finishInstall) {
            this.finishInstall.on(cc.Node.EventType.TOUCH_START, this.onTouchInstallStart, this)
        }
    }

    start() {
        this.updateFinishCardOfSkin()
        this.particleNodeList.forEach(node => {
            node.active = false
        })
    }

    onTouchInstallStart(e: cc.Event.EventTouch) {
        FMgr.Audio.PlayEffect('frame_install')
        FChannelControl.Me.onInstall()
    }

    gameEnd(money?: number) {
        if (!money) {
            money = PGlobalUI.Me.payPalUI.ppCoin
        }

        GameManager.ME.isGameEndAfterAni = true

        cc.log("[FinishUI]gameEnd");
        FMgr.Audio.PlayEffect('firework', 0.7)
        FMgr.Audio.PlayEffect('award', 0.7)
        FMgr.Audio.PlayEffect('win', 0.7)
        FChannelControl.Me.onGameEnd()

        this.node.active = true
        this.node.opacity = 0
        this.node.scale = 0.3

        // 渐变显示
        let delayTime = 0.2
        cc.tween(this.node).delay(delayTime).to(0.2, {opacity: 255, scale: 1.1}).to(0.07, {scale: 1}).call(()=>{
            this.finishInstall.active = true
            this.showOtherParticle()
        }).start()

        // 设置金额
        cc.tween(this.cashLabel).delay(delayTime).call(()=>{
            this.cashLabel.getComponent('FinishLabel').setMoney(money)
        }).start()

        // 手动画
        let moveOffset = 30
        this.hand.runAction(cc.repeatForever(cc.sequence(
            cc.moveBy(0.3, moveOffset, -moveOffset),
            cc.moveBy(0.3, -moveOffset, moveOffset))
        ))

        // 按钮动画
        let scale = this.btn.scale
        this.btn.runAction(cc.repeatForever(cc.sequence(
            cc.scaleTo(0.3, scale - 0.1),
            cc.scaleTo(0.3, scale))
        ))

        this.moveImage()

        this.glass.active = LanguageManager.ME.checkIsUpdateLanguage()
    }

    moveImage() {
        if (!this.isMoveImage) {
            return
        }

        if (!this.imageEndNode) {
            return
        }

        this.imageEndNode.runAction(cc.repeatForever(cc.sequence(
            cc.moveBy(0.3, 0, 30),
            cc.moveBy(0.3, 0, -30))
        ))
    }

    showOtherParticle() {
        this.particleNodeList.forEach(child => {
            child.active = true
            // child.getComponent(cc.ParticleSystem).resetSystem()
        })
    }

    updateFinishCardOfSkin() {
        if (!SkinManager || !SkinManager.ME || !SkinManager.ME.isSkinAdsPlayable) {
            return
        }

        this.paymentNode.active = false
        this.skinNode.active = true

        if (this.btn) {
            this.btn.y -= 80
            this.hand.y -= 80

            let label = this.btn.getChildByName('label')
            if (label) {
                label.getComponent(cc.Label).string = 'Cash Out'
            }
        }
    }
}
