import FChannelControl from "../../_FutureCore/ChannelControl/FChannelControl";

enum CommonGame{
    NONE = 0,  // 用于默认
    TREE = 1,
}

// 数据, Index必须与上面枚举一致。 Icon: icon路径, GameName: 游戏名字, SecondName: 第二个名字, AndroidUrl: 安卓链接, IosUrl: 苹果链接
let CommonData = [
    {Index: CommonGame.TREE, Icon: 'Icon/Tree', GameName: 'GameName_Tree', SecondName: 'SecondName_Tree', AndroidUrl: 'https://play.google.com/store/apps/details?id=com.free.tap.money.tree', IosUrl: 'https://apps.apple.com/us/app/id1536363612'},
]

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {
    @property({
        type: cc.Enum(CommonGame),
        tooltip: "请不要选择为None, 只是用于默认值，为了html文件区分出来",
    })
    public commonCurrentGame: CommonGame = CommonGame.NONE

    @property(cc.Node)
    public bottomUI_Icon: cc.Node = null

    @property(cc.Node)
    public bottomUI_GameName: cc.Node = null

    @property(cc.Node)
    public bottomUI_SecondName: cc.Node = null

    private gameData = null

    start () {
        this.gameData = this.getGameData()
        this.resetGameIcon()
        this.resetGameName()
        this.resetGameSecondName()
        this.resetURL()
    }

    getGameData() {
        for (let item of CommonData) {
            if (item.Index == this.commonCurrentGame) {
                return item
            }
        }

        console.log('配置错误, this.commonCurrentGame = ', this.commonCurrentGame, '可能选择了None.')

        return
    }

    resetGameIcon() {
        if (!this.bottomUI_Icon) {
            return
        }

        if (!this.gameData) {
            return
        }

        if (this.gameData.Icon == '') {
            console.log('Icon为空, 使用默认')
            return
        }

        cc.loader.loadRes(this.gameData.Icon, cc.SpriteFrame, (error, spriteFrame)=>{
            if (error) {
                return
            }

            this.bottomUI_Icon.getComponent(cc.Sprite).spriteFrame = spriteFrame
        })
    }

    resetGameName() {
        if (!this.bottomUI_GameName) {
            return
        }

        if (!this.gameData) {
            return
        }

        if (this.gameData.GameName == '') {
            console.log('GameName为空, 隐藏')
            this.bottomUI_GameName.active = false
            return
        }

        this.bottomUI_GameName.getComponent(cc.Label).string = this.gameData.GameName
    }

    resetGameSecondName() {
        if (!this.bottomUI_SecondName) {
            return
        }

        if (!this.gameData) {
            return
        }

        if (this.gameData.SecondName == '') {
            console.log('SecondName为空, 隐藏')
            this.bottomUI_SecondName.active = false
            return
        }

        this.bottomUI_SecondName.getComponent(cc.Label).string = this.gameData.SecondName

    }

    resetURL() {
        if (!this.gameData) {
            return
        }

        if (this.gameData.AndroidUrl && this.gameData.AndroidUrl != '') {
            FChannelControl.Me.androidAppUrl = this.gameData.AndroidUrl
        }

        if (this.gameData.IosUrl && this.gameData.IosUrl != '') {
            FChannelControl.Me.iOSAppUrl = this.gameData.IosUrl
        }

        FChannelControl.Me.resetChannelUrl()
    }
    // update (dt) {}
}
