/*
    aoemo.com
*/

export namespace V3Extend {
    export function Add(v1: cc.Vec3, v2: cc.Vec3): cc.Vec3{
        return new cc.Vec3(v1.x + v2.x, v1.y + v2.y, v1.z + v2.z);
    }

    export function Sub(v1: cc.Vec3, v2: cc.Vec3): cc.Vec3{
        return new cc.Vec3(v1.x - v2.x, v1.y - v2.y, v1.z - v2.z);
    }

    export function Mult(v1: cc.Vec3, v2: cc.Vec3): cc.Vec3{
        return new cc.Vec3(v1.x * v2.x, v1.y * v2.y, v1.z * v2.z);
    }

    export function Div(v1: cc.Vec3, v2: cc.Vec3): cc.Vec3{
        return new cc.Vec3(v1.x / v2.x, v1.y / v2.y, v1.z / v2.z);
    }

    export function AddNum(v1: cc.Vec3, num: number): cc.Vec3{
        return new cc.Vec3(v1.x + num, v1.y + num, v1.z + num);
    }

    export function SubNum(v1: cc.Vec3, num: number): cc.Vec3{
        return new cc.Vec3(v1.x - num, v1.y - num, v1.z - num);
    }

    export function MultNum(v1: cc.Vec3, num: number): cc.Vec3{
        return new cc.Vec3(v1.x * num, v1.y * num, v1.z * num);
    }

    export function DivNum(v1: cc.Vec3, num: number): cc.Vec3{
        return new cc.Vec3(v1.x / num, v1.y / num, v1.z / num);
    }

    export function Add0(v1: cc.Vec3, v2: cc.Vec3): cc.Vec3{
        return new cc.Vec3(v1.x + v2.x, v1.y + v2.y, 0);
    }

    export function Sub0(v1: cc.Vec3, v2: cc.Vec3): cc.Vec3{
        return new cc.Vec3(v1.x - v2.x, v1.y - v2.y, 0);
    }

    export function Mult0(v1: cc.Vec3, v2: cc.Vec3): cc.Vec3{
        return new cc.Vec3(v1.x * v2.x, v1.y * v2.y, 0);
    }

    export function Div0(v1: cc.Vec3, v2: cc.Vec3): cc.Vec3{
        return new cc.Vec3(v1.x / v2.x, v1.y / v2.y, 0);
    }

    export function AddNum0(v1: cc.Vec3, num: number): cc.Vec3{
        return new cc.Vec3(v1.x + num, v1.y + num, 0);
    }

    export function SubNum0(v1: cc.Vec3, num: number): cc.Vec3{
        return new cc.Vec3(v1.x - num, v1.y - num, 0);
    }

    export function MultNum0(v1: cc.Vec3, num: number): cc.Vec3{
        return new cc.Vec3(v1.x * num, v1.y * num, 0);
    }

    export function DivNum0(v1: cc.Vec3, num: number): cc.Vec3{
        return new cc.Vec3(v1.x / num, v1.y / num, 0);
    }
}