/**
 * 渲染摄像机区域显示在指定位置
 * 实践:自定义渲染显示区域
 * 注意事项:存在两个摄像机 target carema 和 view camera 
 * target carema 指定渲染, view camera 显示
 * view_node 节点属于view camera 渲染范围
 * view_node 带有cc.Sprite 组件
 */

import { _decorator, Component, Camera, Size, size, Sprite, RenderTexture, game, SpriteFrame, v3, gfx } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('CameraRender')
export default class CameraRender extends Component {
    @property({ type: Camera, tooltip: "设置显示", visible: true })
    private target_Camera: Camera | null = null;
    @property({ type: Size, tooltip: "视图大小" })
    public view_size: Size = size(1280, 720);

    onload() {
        if (!this.node.getComponent(Sprite)) {
            this.node.addComponent(Sprite);
        }
    }
    start() {
        this.init_camera_render(this.view_size, this.target_Camera);
    }

    /**
      * 初始化渲染相机
      */
    private init_camera_render(view_size: Size, data_camera: Camera) {
        //设置相机的targetTexture
        let renderTexture = new RenderTexture();
        renderTexture.initialize({
            width: view_size.width,
            height: view_size.height
            // passInfo: gfx.RenderPassInfo,
            // externalResLow: number,
            // externalResHigh: number,
            // externalFlag: gfx.TextureFlags
        });
        data_camera.targetTexture = renderTexture;
        //实例化图像数据
        let renderSpriteFrame = new SpriteFrame();
        renderSpriteFrame.texture = renderTexture;

        //显示渲染数据
        let sprite: Sprite = this.node.getComponent(Sprite);
        sprite.spriteFrame = renderSpriteFrame;

        sprite.node.scale = v3(1, -1, 1);

    }
}