
import { _decorator, Component, Node, AudioSource, resources, error, AudioClip } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = CocosAudio
 * DateTime = Tue Feb 08 2022 11:52:54 GMT+0800 (中国标准时间)
 * Author = warde.huang
 * FileBasename = CocosAudio.ts
 * FileBasenameNoExtension = CocosAudio
 * URL = db://assets/CocosAudio.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */

@ccclass('CocosAudioOneShot')
export class CocosAudioOneShot extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    start() {
        // [3]
        this.node.on("click", this.onClick, this);
    }

    // update (deltaTime: number) {
    //     // [4]
    // }

    async onClick() {
        let source = this.node.addComponent(AudioSource);
        let clip = await this.aLoad("menu_click_08", AudioClip);
        source.playOneShot(clip);
    }

    async aLoad(path: string, type: any, onProgress?: (finish: number, total: number, item: any) => void): Promise<any> {
        let asset = resources.get(path, type);
        if (asset) {
            if (onProgress) {
                onProgress(1, 1, asset);
            }
            return asset;
        }
        return new Promise(resolve => {
            this.load(path, type, resolve, onProgress);
        });
    }

    load(path: any, type: any, onComplete: (asset: any) => void, onProgress?: (finish: number, total: number, item: any) => void) {
        if (!path) {
            error('bad path when load res');
            return;
        }
        let asset = resources.get(path, type);
        if (asset) {
            if (onProgress) {
                onProgress(1, 1, asset);
            }
            onComplete(asset);
            return;
        }
        resources.load(path, type, onProgress as any, (err, asset) => {
            if (err) {
                error('load asset failed', path, err);
                onComplete(null);
                return;
            }
            onComplete(asset);
        });
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.3/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.3/manual/zh/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.3/manual/zh/scripting/life-cycle-callbacks.html
 */
