
import { _decorator, Component, Node, AudioSource, resources, error, AudioClip } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = CocosAudio
 * DateTime = Tue Feb 08 2022 11:52:54 GMT+0800 (中国标准时间)
 * Author = warde.huang
 * FileBasename = CocosAudio.ts
 * FileBasenameNoExtension = CocosAudio
 * URL = db://assets/CocosAudio.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */

@ccclass('WechatAudio')
export class WechatAudio extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    start() {
        // [3]
        this.node.on("click", this.onClick, this);
    }

    // update (deltaTime: number) {
    //     // [4]
    // }

    async onClick() {
        let innerAudioContext = wx.createInnerAudioContext({
            useWebAudioImplement: true
        });
        innerAudioContext.src = 'Audio/menu_click_08.mp3';
        innerAudioContext.loop = false;
        innerAudioContext.volume = 1;

        innerAudioContext.onError((res) => {
            innerAudioContext.destroy();
        });
        innerAudioContext.onStop((res) => {
            innerAudioContext.destroy();
        });
        innerAudioContext.play();
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.3/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.3/manual/zh/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.3/manual/zh/scripting/life-cycle-callbacks.html
 */
